<?php
global $wp_query;
$term = $wp_query->queried_object;
$args = [
    'posts_per_page' => -1,
    'post_type' => 'property',
    'tax_query' => [
        [
            'taxonomy'  => $term->taxonomy,
            'field'     => 'slug',
            'terms'     => $term->slug,
        ],
    ]
];
$propertyTypeQuery = new WP_Query($args);
?>

<div class="banner-wrapper">
    <div class="container">
        <div class="page-header">
            <h1>Property Type - <?= $term->name ?></h1>
        </div>
    </div>
</div>

<div class="container">
    <div class="property-output">
        <?php
        if($propertyTypeQuery->have_posts()) {
            while ($propertyTypeQuery->have_posts()) {
                $propertyTypeQuery->the_post();

                $propertyImage = get_the_post_thumbnail_url() ? : get_template_directory_uri() . '/dist/images/blair-castle-default.png';
                $imageClass = get_the_post_thumbnail_url() ? 'featured-property' : 'default-image';

                ?>

                <article class="property-item">
                    <div class="row">

                            <div class="col-lg-4">
                                <div class="image-holder <?= $imageClass; ?>">
                                    <a href="<?php the_permalink(); ?>">
                                    <img src="<?= $propertyImage; ?>" alt="<?php the_title(); ?>">
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                <h3><?php the_field('address'); ?></h3>
                                <h4><?php the_field('price'); ?></h4>
                                <?php the_excerpt(); ?>
                            </div>
                        </a>
                    </div>
                </article>

            <?php }
        } else { ?>

            <div class="no-properties">
                <?php 
                $noResultsMessage = get_field('default_no_results_message' , $term->id) ?? "Sorry, we currently have no properties available at the moment.";
                echo $noResultsMessage;
                ?> 
            </div>

        <?php } ?>
    </div>
</div>
