/* ========================================================================
 * DOM-based Routing
 * Based on http://goo.gl/EUTi53 by Paul Irish
 *
 * Only fires on body classes that match. If a body class contains a dash,
 * replace the dash with an underscore when adding it to the object below.
 *
 * .noConflict()
 * The routing is enclosed within an anonymous function so that you can
 * always reference jQuery with $, even when in .noConflict() mode.
 * ======================================================================== */


(function($) {



    // Breakpoints to match Bootstrap.
    var screenSmMin = 768,
        screenMdMin = 990,
        screenLgMin = 1200,
        screenXlMin = 1500;


    var siteHeader,
        headerHeight;


    // Use this variable to set up the common and page specific functions. If you
    // rename this variable, you will also need to rename the namespace below.
    var Sage = {
        // All pages
        'common': {
            init: function() {
                $('.menu-book-tickets a').each(function() {
                    $(this).bind('click', function() {
                        // Only send Event, PageView already registered.
                        ga("send", {
                            hitType: 'event',
                            eventCategory: 'BookCastleTickets',
                            eventAction: 'BookingCastleClick',
                            eventLabel: 'CastleBooking',
                            page: window.location.toString()
                        });
                    });
                });

                // Get the modal
                var modal = document.getElementById("covidModal");

                // Get the <span> element that closes the modal
                var span = document.getElementsByClassName("close")[0];

                if (modal) {
                    // When the user clicks on the button, open the modal
                    $(document).ready(function() {
                        modal.style.display = "block";
                    });
    
                    // When the user clicks on <span> (x), close the modal
                    span.onclick = function() {
                        modal.style.display = "none";
                    }
    
                    // When the user clicks anywhere outside of the modal, close it
                    window.onclick = function(event) {
                        if (event.target == modal) {
                            modal.style.display = "none";
                        }
                    }
                }



                // JavaScript to be fired on all pages
                $('body').removeClass('no-js');
                siteHeader = $('header.banner');
                headerHeight = siteHeader.outerHeight(true);
                if ($('.page-template-template-portal').length > 0) {
                    headerHeight = headerHeight - 200;
                }

                // Toggle Mobile push/slide nav
                $('.navbar-toggle.push').on('click', function() {
                    tgt = $(this).data('target') + ', .logo-container';
                    if ($(tgt).hasClass('pushed')) {
                        $(this).attr('aria-expanded', 'false');
                    } else {
                        $(this).attr('aria-expanded', 'true');
                    }
                    $(tgt).toggleClass('pushed');

                });

                // Set mini/normal header on scroll
                $(window).on('scroll load', function() {
                    if ($(window).scrollTop() > headerHeight) {
                        siteHeader.addClass('mini');
                    } else {
                        siteHeader.removeClass('mini');
                    }

                    // Banner portal scroll
                    if ($(window).scrollTop() > 5) {
                        $('.banner.portal .heading-wrap h1').fadeOut(100);
                    } else {
                        $('.banner.portal .heading-wrap h1').fadeIn(100);
                    }

                });

                // Gallery lightboxes
                // Colorboxing for images with .zoom class
                /*  $("figure.gallery-item a").colorbox({
                rel:'gallery',
                maxHeight:'100%'
            });
            $( window ).resize(function() {
                $.colorbox.resize({width:'90%', maxHeight:'90%'});
            });
        */
                $("figure.gallery-item a").addClass('strip').attr({ 'data-strip-group': 'galGroup', 'data-strip-options': 'side: "left"' });



                // Drop down toggles
                $('.menu-item-has-children .sub-menu').before('<a data-target=".my-dropdown" class="my-dropdown-toggle" href="#"><span class="fa fa-angle-down"></span></a>');
                $(window).click(function() {
                    if ($('.navTopTrigger').hasClass('open')) {
                        $('.navTopTrigger').removeClass('open');
                    }
                    $('footer a.img-link').removeClass('open');
                });

                $('.my-dropdown-toggle').on('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    tgt = $(this).attr('data-target');
                    toggle = 1;
                    if (tgt === '.my-dropdown') {
                        tgt = $(this).closest('.menu-item-has-children');
                    } else {
                        tgt = $(tgt);
                    }
                    if (toggle === 1) {
                        tgt.toggleClass('open');
                    } else {
                        tgt.addClass('open');
                    }
                });


                $('.dropdown-toggle').click(function() {
                    $(this).parent().toggleClass('open');
                });
                // What's On link override on mobile.
                $('.iconToggle').on('click', function(e) {
                    if ($(window).outerWidth() < screenSmMin) {
                        link = $(this).attr('data-mobile-href');
                        if (link !== undefined) {
                            e.stopPropagation();
                            window.location.href = link;
                        }
                    }
                    const mainHeaderHeight = $('.main-nav-container').height();

                    $('#collapseEvents').attr('style', "top:"+mainHeaderHeight + "px;");
                });



                $('.navTopTrigger, .dropNavTrigger , footer a.img-link').on('focus, click', function(e) {
                    if ($(window).outerWidth() < screenLgMin) {
                        if ($(this).is('a')) {
                            myHref = $(this).attr('href');
                        } else {
                            myHref = '#';
                        }

                        if (myHref.length < 2) {
                            e.preventDefault();
                            e.stopPropagation();
                            $(this).toggleClass('open');
                        }
                    }
                });

                // Smooth scroll to target
                var scrollToTarget = function(tgtEl, siteHeader, scrollSpeed, additionalOffset) {
                    if (scrollSpeed === undefined) { scrollSpeed = 500; }
                    // is header fixed?
                    hoffset = 0;
                    extraOffset = 0;
                    if (siteHeader !== undefined) {
                        if (siteHeader.css('position') === 'fixed') {
                            hoffset = siteHeader.outerHeight(true);
                        }
                    }
                    if (additionalOffset !== undefined) {
                        extraOffset = additionalOffset.outerHeight(true);
                    }
                    scrollToLoc = tgtEl.offset().top - (hoffset + extraOffset);
                    $('html, body').animate({
                        scrollTop: scrollToLoc
                    }, scrollSpeed);
                };

                $('.toTop').on('click', function(e) {
                    e.preventDefault();
                    tgtEl = $('body');
                    siteHeader = $('header.banner');
                    additionalOffset = $('header.banner .brand');
                    scrollSpeed = 500;
                    scrollToTarget(tgtEl, siteHeader, scrollSpeed, additionalOffset);
                });

                // Calendars and Datepickers
                $('#calendar-datepicker').datetimepicker({
                    inline: true,
                    format: 'MM/dd/YYYY'
                });
                $('.datepicker td.day').on('click', function() {
                    $('.datepicker td.day').removeClass('opened');
                    $(this).addClass('opened');
                });

                var $flexCount = $('.flexslider').length;

                if($flexCount > 1) {
                    $('.custom-controls-container').each(function (index) {
                        $(this).addClass('slider-' + index);
                    });
                    $('.custom-navigation').each(function (index) {
                        $(this).addClass('slider-' + index);
                    });
                    $('.flexslider').each(function (index) {
                        $(this).addClass('slider-' + index);

                        $(this).flexslider({
                            animation: "slide",
                            controlsContainer: $(".custom-controls-container.slider-" + index),
                            customDirectionNav: $(".custom-navigation.slider-" + index + " a")
                        });
                    });
                }else{
                    // Find and ini any flexsliders
                    $('.flexslider').flexslider({
                        animation: "slide",
                        controlsContainer: $(".custom-controls-container"),
                        customDirectionNav: $(".custom-navigation a")
                    });
                }

                $('.flexslider-w-thumb-pager').flexslider({
                    animation: "slide",
                    controlsContainer: $(".thumb-pager"),
                    customDirectionNav: $(".custom-navigation a"),
                    controlNav: "thumbnails"
                });
                fslideCount = $('.flexslider-w-thumb-pager .slides').find('li:not(.clone)').length;
                if (fslideCount > 1) {
                    $('.custom-navigation.w-thumb-pager').removeClass('hidden');
                }

                $('.main-banner-flexslider').flexslider({
                    animation: "slide",
                    controlsContainer: $(".custom-controls-container"),
                    customDirectionNav: $(".custom-navigation a")
                });

                // Twitter widget
                if ($('#twitterBox').length > 0) {
                    el = $('#twitterBox');
                    twitterHandle = el.attr('data-handle');
                    el.append('<div id="twitterFetcher"></div>');
                    var configProfile = {
                        "profile": { "screenName": twitterHandle },
                        "domId": 'twitterFetcher',
                        "maxTweets": 1,
                        "enableLinks": true,
                        "showUser": false,
                        "showTime": false,
                        "showImages": false,
                        "showInteraction": false,
                        "lang": 'en'
                    };
                    twitterFetcher.fetch(configProfile);
                }

                var setBoxHeights = function(me, elSelector, breakpoint, maxBreakpoint) {
                    if (maxBreakpoint === undefined) {
                        maxBreakpoint = 999999999;
                    }
                    prevEl = me.prev(elSelector);
                    prevEl.css('height', '');
                    winWidth = $(window).outerWidth();

                    hite = 'min-height'; // 'height';
                    if (winWidth > breakpoint - 1 && winWidth < maxBreakpoint) {
                        // Find tallest el in collection
                        //   Reset heights

                        prevEl.css(hite, '');
                        rand = Math.floor(Math.random() * (10000 - 1 + 1)) + 1; // Can't get 'nextUntil' to push to an array, so this is my workaround.
                        fixClass = 'fixHeight' + rand + 'Me';
                        prevEl.nextUntil(':not(' + elSelector + ')').css(hite, '').addClass(fixClass);

                        newHeight = prevEl.outerHeight();
                        var heights = [];
                        // heights.push( prevEl.nextUntil(':not('+elSelector+')'));//.outerHeight());
                        //heights = prevEl.map(function() {
                        //    return $(this).add(prevEl.nextUntil(':not('+elSelector+')'));
                        //}).get();
                        $('.' + fixClass).each(function() {
                            heights.push($(this).outerHeight());
                        });
                        var arrayLength = heights.length;
                        for (var i = 0; i < arrayLength; i++) {
                            if (heights[i] > newHeight) {
                                newHeight = heights[i];
                            }
                        }

                        newHeight++; // Add one extra pixel just to be safe.
                        prevEl.nextUntil(':not(' + elSelector + ')').css(hite, newHeight);
                        prevEl.css(hite, newHeight);
                        $('.' + fixClass).removeClass(fixClass); // Remove unique class once we're finished.
                    } else {
                        // Outside breakpoints? Reset inline height.
                        prevEl.nextUntil(':not(' + elSelector + ')').css(hite, '');
                        prevEl.css(hite, '');
                    }
                };
                $('#mixContainer').mixItUp();
                $('#mixFilters a').on('click', function(e) {
                    e.preventDefault();
                    $(this).parent().trigger('click');
                    setTimeout(function() {
                        $('.category-event .bordered-row>div').eq(1).each(function() {
                            me = $(this);

                            elSelector = '[class*="col-sm-"]';
                            breakpoint = screenSmMin;
                            setBoxHeights(me, elSelector, breakpoint);
                        });
                    }, 750);
                });

                var boxHeightInterval = setInterval(function() { $(window).resize(); }, 500); // Trigger setBoxHeights for a few seconds after page load.
                setTimeout(function() { clearInterval(boxHeightInterval); }, 2600);



                $(window).on('resize load', function() {

                    var winWidth = $(window).outerWidth();

                    // Left column block position swap on < sm screens
                    if (winWidth < screenSmMin) {
                        $('.blockswrapper>.blockscontent').prependTo($('.blockswrappermobile'));
                    } else {
                        $('.blockswrappermobile>.blockscontent').prependTo($('.blockswrapper'));
                    }

                    // Scroll to fixed items
                    if (winWidth < screenMdMin) {
                        $('.scrollFix').trigger('detach.ScrollToFixed');
                    } else {
                        $('.scrollFix').trigger('detach.ScrollToFixed');
                        $('.scrollFix').scrollToFixed();
                    }


                    // Featurebox match heights.
                    $('.feature-box.col-md-6:nth-child(2)').each(function() {
                        me = $(this);
                        elSelector = '.feature-box.col-md-6';
                        breakpoint = screenMdMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });


                    $('.pre-footer .col-sm-6').eq(1).each(function() {
                        me = $(this);
                        elSelector = '.col-sm-6';
                        breakpoint = screenSmMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });

                    $('.page-template-template-home-blair .feature-box.col-xs-6').eq(1).each(function() {
                        me = $(this);
                        elSelector = '.feature-box.col-xs-6';
                        breakpoint = 0; //screenMdMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });
                    $('.page-template-template-home-blair .feature-box.col-xs-12').eq(1).each(function() {
                        me = $(this);
                        elSelector = '.feature-box.col-xs-12';
                        breakpoint = screenMdMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });
                    $('.page-template-template-4by4 .feature-box.col-xs-12').eq(1).each(function() {
                        me = $(this);
                        elSelector = '.feature-box.col-xs-12';
                        breakpoint = 0; //screenMdMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });
                    /*
                    $('.page-template-template-home-blair .bordered-row .col-md-4').eq(1).each(function() {
                        me = $(this);
                        elSelector = '.bordered-row .col-md-4';
                        breakpoint = screenMdMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });*/

                    $('.page-template-template-no-carousel .feature-box.col-xs-6').eq(1).each(function() {
                        me = $(this);
                        elSelector = '.feature-box.col-xs-6';
                        breakpoint = 0; //screenMdMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });
                    $('.page-template-template-no-carousel .bordered-row .col-md-4').eq(1).each(function() {
                        me = $(this);
                        elSelector = '.bordered-row .col-md-4';
                        breakpoint = screenMdMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });


                    $('.page:not(.page-template-template-home-blair) .feature-box.col-xs-6:nth-child(2)').each(function() {
                        me = $(this);
                        elSelector = '.feature-box.col-xs-6';
                        breakpoint = 0;
                        maxBreakpoint = screenMdMin;
                        setBoxHeights(me, elSelector, breakpoint, maxBreakpoint);
                    });

                    $('.category .article-container').eq(1).each(function() {
                        me = $(this);

                        elSelector = '.article-container';
                        breakpoint = screenSmMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });

                    $('.blog .event-container.col-sm-3').eq(1).each(function() {
                        me = $(this);
                        elSelector = '.event-container.col-sm-3';
                        breakpoint = screenSmMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });

                    $('.rpbt_shortcode .col-xs-6').eq(1).each(function() {
                        me = $(this);
                        elSelector = '.col-xs-6';
                        breakpoint = 0;
                        setBoxHeights(me, elSelector, breakpoint);
                    });

                    $('.featured-events>.row .col-sm-6').eq(1).each(function() {
                        me = $(this);
                        elSelector = '.col-sm-6';
                        breakpoint = screenSmMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });
                    $('.height-match').eq(1).each(function() {
                        me = $(this);
                        elSelector = '.col-sm-6';
                        breakpoint = screenSmMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });



                    $('.category-event .bordered-row>div, .post-type-archive-event .bordered-row>div').eq(1).each(function() {
                        me = $(this);

                        elSelector = '[class*="col-sm-"]';
                        breakpoint = screenSmMin;
                        //setBoxHeights(me,elSelector,breakpoint);
                    });
                    // for Mixitup... clunky, but works.
                    setTimeout(function() {
                        $('.category-event .bordered-row>div, .post-type-archive-event .bordered-row>div').eq(1).each(function() {
                            me = $(this);

                            elSelector = '[class*="col-sm-"]';
                            breakpoint = screenSmMin;
                            //  setBoxHeights(me,elSelector,breakpoint);
                        });
                    }, 750);

                    $('.related-articles>div').eq(1).each(function() {
                        me = $(this);

                        elSelector = '[class*="col-sm-"]';
                        breakpoint = 0;
                        setBoxHeights(me, elSelector, breakpoint);
                    });

                    $('.portal .lower-panels .bordered-row> .col-sm-6, .page-template-template-portal .lower-panels .bordered-row> .col-sm-6').eq(1).each(function() {
                        me = $(this);

                        elSelector = '.col-sm-6';
                        breakpoint = screenSmMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });
                    $('.portal .lower-panels .bordered-row>.col-sm-4, .page-template-template-portal .lower-panels .bordered-row>.col-sm-4').eq(1).each(function() {
                        me = $(this);

                        elSelector = '.col-sm-4';
                        breakpoint = screenSmMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });

                    $('.team-col>.col-sm-3').eq(1).each(function() {
                        me = $(this);

                        elSelector = '.col-sm-3';
                        breakpoint = screenSmMin;
                        setBoxHeights(me, elSelector, breakpoint);
                    });

                    // Content height for pages
                    if ($(window).width() < 1024) {

                        if ($('.the-content').length > 0) {
                            lc = 0;
                            sb = 0;
                            fi = 0;
                            sliderhi = 0;
                            minHi = 1;
                            if ($('.left-col').length > 0) {
                                lc = $('.left-col').outerHeight(true);
                            }
                            if ($('.sidebar').length > 0) {
                                sb = $('.sidebar').outerHeight(true);
                            }
                            if ($('.featured-img').length > 0) {
                                fi = $('.featured-img').outerHeight(true);
                            }
                            if ($('.flexslider-w-thumb-pager').length > 0) {
                                sliderhi = $('.flexslider-w-thumb-pager').outerHeight(true);
                            }


                            lc = lc - fi - sliderhi;
                            if (lc > minHi) {
                                minHi = lc;
                            }
                            if (sb > minHi) {
                                minHi = sb;
                            }
                            winWidth = $(window).outerWidth();
                            breakpoint = screenMdMin;
                            maxBreakpoint = 9999999;
                            if (winWidth > breakpoint - 1 && winWidth < maxBreakpoint) {
                                $('.the-content').css('min-height', minHi);
                            } else {
                                $('.the-content').css('min-height', '');
                            }
                        }
                    }

                    // Left column blocks - move for -sm and -md breakpoints
                    bloks = $('.block-wrapper');
                    if (winWidth > screenSmMin - 1) {
                        // .blocks div goes under the left hand nav.
                        bloks.appendTo('.left-col');
                    } else {
                        // .blocks div goes at the top of the sidebar.
                        bloks.prependTo('div.sidebar');
                    }

                }); // End on resize/load block.
                
                $('.navbar-toggle').on('click', function(){
                    const windowWidth = $(window).width();
                    if($(this).attr('aria-expanded') == 'true'){
                        $(this).html('<i class="fa fa-times"></i>');                        
                        
                        if(windowWidth > 990){
                            var mainHeaderHeight = 0;
                            if ($('.portal.new-menu').length > 0){
                                mainHeaderHeight = $('.fixed-menu-row').height() + $('.nav-top').height();
                            } else {
                                mainHeaderHeight = $('.main-nav-container').height();
                            }

                            $('#mainNav').attr('style', "top:"+mainHeaderHeight + "px;margin-top:0px;");
                        }
                        else{
                            var topMenuHeight = 0;
                            var marginTopMenu = "margin-top:-1px";
                            if ($('.portal.new-menu').length > 0){
                                topMenuHeight = $('.nav-top').height();
                                marginTopMenu = "margin-top:-15px";
                            } else {
                                topMenuHeight = $('.header-links-container').height();
                            }
                            $('#mainNav').attr('style', "display: block;"+marginTopMenu+";top:-"+topMenuHeight + "px;max-height: calc(100vh - "+topMenuHeight+"px);");
                        }
                        $('body').append("<div class='veil'></div>");
                    }
                    else{
                        $('.veil').remove();
                        $(this).html('<i class="fa fa-bars"></i>');
                        
                        if(windowWidth > 990){
                            $('#mainNav').attr('style', "top:-500%");
                        }
                        else{
                            $('#mainNav').attr('style', "display: none;");
                        }
                    }
                })
                if($(window).width() < 991){
                    $('.menu-item-has-children').on('click', function(){
                        if(!$(this).children('.sub-menu').hasClass('submenu-open')){
                            $('.submenu-open').removeClass('submenu-open');
                            $(this).children('.sub-menu')
                                .addClass('submenu-open');
                        } else {
                            $('.submenu-open').removeClass('submenu-open');
                        }
                        
                    })
                }
                $('#searchsubmit').prependTo('.search-form');
            },
            finalize: function() {
                // JavaScript to be fired on all pages, after page specific JS is fired
            }
        },
        // Home page
        'home': {
            init: function() {
                // JavaScript to be fired on the home page
            },
            finalize: function() {
                // JavaScript to be fired on the home page, after the init JS
            }
        },
        // About us page, note the change from about-us to about_us.
        'about_us': {
            init: function() {
                // JavaScript to be fired on the about us page
            }
        },
        'single_property': {
            init: function() {

            },
            finalize: function() {
                var galleryThumbs = new Swiper('.gallery-thumbs', {
                    spaceBetween: 10,
                    slidesPerView: 4,
                    freeMode: true,
                    watchSlidesVisibility: true,
                    watchSlidesProgress: true,
                });
                var galleryTop = new Swiper('.gallery-top', {
                    spaceBetween: 10,
                    navigation: {
                        nextEl: '.swiper-button-next',
                        prevEl: '.swiper-button-prev',
                    },
                    thumbs: {
                        swiper: galleryThumbs
                    }
                });
            }
        },
    };

    // The routing fires all common scripts, followed by the page specific scripts.
    // Add additional events for more control over timing e.g. a finalize event
    var UTIL = {
        fire: function(func, funcname, args) {
            var fire;
            var namespace = Sage;
            funcname = (funcname === undefined) ? 'init' : funcname;
            fire = func !== '';
            fire = fire && namespace[func];
            fire = fire && typeof namespace[func][funcname] === 'function';

            if (fire) {
                namespace[func][funcname](args);
            }
        },
        loadEvents: function() {
            // Fire common init JS
            UTIL.fire('common');

            // Fire page-specific init JS, and then finalize JS
            $.each(document.body.className.replace(/-/g, '_').split(/\s+/), function(i, classnm) {
                UTIL.fire(classnm);
                UTIL.fire(classnm, 'finalize');
            });

            // Fire common finalize JS
            UTIL.fire('common', 'finalize');
        }
    };


    // Load Events
    $(document).ready(UTIL.loadEvents);

})(jQuery); // Fully reference jQuery after this point.
