
<div class="container">
    <?php

    use Roots\Sage\Titles; ?>
    <div class="page-header">
        <h1>What's On</h1>
        <p class="subheading">Events at Blair Castle</p>
    </div>
</div>
<div class="container">
    <div class="featured-events">
        <div class="row">
            <?php get_template_part('templates/events/featured-event'); ?>
        </div>
    </div>
</div>

<?php
$args = array(
    'posts_per_page' => -1,
    'meta_key' => 'b2_event_start_date',
    'orderby' => 'meta_value_num',
    'post_type' => 'event',
    'order' => 'ASC',
    'meta_query' => array(
        'relation' => 'OR',
        array(
            'key' => 'b2_event_start_date',
            'value' => date('Ymd'),
            'compare' => '>='
        ),
        array(
            'key' => 'b2_event_end_date',
            'value' => date('Ymd'),
            'compare' => '>='
        )
    ),
);
$events = new WP_Query($args);
?>
<div class="container post-container">
    <div class="row bordered-row">
        <div class="events-col col-sm-6 " id="mixContainer">
            <?php if (!$events->have_posts()) { ?>
                <div class="alert alert-warning">
                    <?php _e('Sorry, no results were found.', 'sage'); ?>
                </div>
                <?php get_search_form(); ?>
            <?php } ?>
            <?php
            while ($events->have_posts()) {
                $events->the_post();
                ?>
                <?php
                $cats = ''; //strtolower(wp_strip_all_tags(get_the_category_list(' ')));
                foreach (wp_get_post_terms($post->ID, 'event-category') as $category) {
                    $cats .= 'filter-' . $category->slug . ' ';
                }
                ?>
                <div class="event-container mix <?php echo $cats; ?>">
                    <?php get_template_part('templates/content', 'archive-event'); ?>
                </div>
            <?php } ?>
        </div>
        <div class="col-sm-6 col-md-3 left-col cat-nav-col">
            <div class="box scrollFix">
                <?php
                $list = wp_list_pluck($events->posts, 'ID');
                $terms = wp_get_object_terms($list, 'event-category');

                $postTerm = get_the_terms(get_the_ID(), 'event-category');
                ?>

                <p class="dropNavTrigger">Select by Category <span class="fa fa-chevron-right visible-xs"></span></p>
                <div class="nav">
                    <ul id="mixFilters">
                        <li class="filter" data-filter="all"><a href="/events">All <strong>(<?php echo $events->post_count; ?>)</strong></a></li>
                        <?php
                        foreach ($terms as $term) {
                            $termLink = get_term_link($term);
                            if($term->name != 'Special Event'){ ?>
                                <li class="filter" data-filter="<?php echo '.filter-' . $term->slug; ?>"><a href="<?php echo $termLink; ?>"><?php echo $term->name; ?></a></li>
                            <?php }
                        } ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="right-col calendar-wrapper col-sm-6 col-md-3">
            <div class="box scrollFix">
                <?php get_template_part('templates/feature/events-calendar'); ?>
            </div>
        </div>
        <?php // the_posts_navigation();       ?>
        
    </div>
</div>