<?php
$category = get_the_category();
$catParID = $category[0]->category_parent;
$catParentName = get_cat_name($catParID);
if (strlen($catParentName) == 0) {
    $catParID = $category[0]->cat_ID;
    $catParentName = get_cat_name($catParID);
}
$catParentLink = get_category_link($catParID);

$this_category = get_category($catParID);
if ($this_category->term_taxonomy_id) {
    $catParID = $this_category->term_taxonomy_id;
}
?>

<div class="container post-container<?php echo ' category-' . strtolower($this_category->slug); ?>" itemscope itemtype="http://schema.org/Blog">
    <div class="row">
        <?php
        while (have_posts()) {

            the_post();
            ?>
            <header>
                <h1 class="entry-title"  itemprop="headline"><?php the_title(); ?></h1>
                <div class="post-header-links">
                    <?php get_template_part('templates/entry-meta'); ?>
                    <?php next_post_link('%link', 'Next Article >>'); ?>
                    <!--<a class="viewmore" href="">Next Article</a>-->
                </div>
            </header>
            <div class="col-sm-4 col-lg-3 left-col">

                <?php
//                $cats = get_categories('child_of=' . $catParID . '');
//                echo '<p class="dropNavTrigger">Filter by Category <span class="fa fa-chevron-right visible-xs"></span></p>';
//                echo '<div class="nav"><ul>';
//                echo '<li><a href="' . $catParentLink . '">All ' . $catParentName . '<strong> (' . $category[0]->category_count . ')</strong></a></li>';
//                foreach ($cats as $category) {
//                    printf('<li class="filter"><a href="%1$s">%2$s</a></li>', esc_url(get_category_link($category->term_id)), esc_html($category->name)
//                    );
//                }
//                echo '</ul></div>';

                $cat = wp_list_categories('title_li=&echo=0');
                ?>

                  <p class="dropNavTrigger"><?php _e('Archives'); ?><span class="fa fa-chevron-right visible-xs"></span></p>
                        <div class="nav">
                            <ul class="archive-filters">
                            <?php 
                                $args = array(
                                	'type'            => 'yearly',
                                	'limit'           => '',
                                	'format'          => 'html', 
                                	'before'          => '<span class="nofilter" data-filter=".filter-"> ',
                                	'after'           => '</span>',
                                	'show_post_count' => false,
                                	'echo'            => 1,
                                	'order'           => 'DESC',
                                    'post_type'     => 'post'
                                );
                                wp_get_archives( $args ); ?>

                                <li><a href="/news/">News</a></li>
                                <li><a href="/category/blog/">Blogs</a></li>

                            </ul>
                        </div>
                <?php
                if (have_rows('features_repeater')) {
                    while (have_rows('features_repeater')) {
                        the_row();
                        get_template_part('templates/feature/feature-news');
                    }
                }
                ?>

            </div>

            <div class="col-sm-8 col-lg-9">
                <?php
                $bannerImage = wp_get_attachment_image_src(get_post_thumbnail_id(), "header image") ? wp_get_attachment_image_src(get_post_thumbnail_id(), 'header image') : array("https://dummyimage.com/1900x1000/cccccc/000000.jpg&text=Pending+");
                $bannerImageAlt = get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true);
                ?>
                <img class="img-responsive featured-img" itemscope itemtype="http://schema.org/ImageObject" itemprop="contentUrl" src="<?php echo $bannerImage[0]; ?>" alt="<?php echo $bannerImageAlt; ?>" title="<?php echo $bannerImageAlt; ?>"/>

                <div class="the-content">
                    <article <?php post_class(); ?>>

                        <div class="entry-content" itemprop="text">
                            <?php the_content(); ?>
                        </div>

                    </article>
                </div>
            </div>
            <div class="related-articles bordered-row">

                <?php
                $relatedPosts = do_shortcode("[related_posts_by_tax posts_per_page='4' title='Articles you may also like' format='thumbnails'] ");
                echo $relatedPosts;
                ?>
            </div>
        <?php } ?>
    </div>
</div>
