<?php
/**
 * Template Name: No Carousel Template
 */
the_content();
if (!post_password_required($post)) {

    ?>
    <div class="banner-wrapper">
        <?php
        $bannerMedia = get_field('banner_media');
        if ($bannerMedia == 'image') {
            get_template_part('templates/image/image-banner');
        } elseif ($bannerMedia == 'slider') {
            get_template_part('templates/slider/slider-banner');
            ?>

            <?php
        } elseif ($bannerMedia == 'video') {
            while (have_rows('banner_video_repeater')) {
                the_row();
                get_template_part('templates/video/video-banner');
            }
        }
        ?>
         <div class="banner-overlay">
            <div class="container">
                <div class="banner-container">        
                    <?php get_template_part('templates/page', 'header'); ?>
                    <?php if (get_field('banner_caption')){ ?>
                        <div class="banner-caption"><?= get_field('banner_caption') ?: ''; ?></div>
                    <?php } ?>  
                    <?php if (get_field('banner_button_link')){ ?>
                        <a href='<?= get_field('banner_button_link');?>'><div class="btn more-info-button"><?= get_field('banner_button_text');?></div></a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="container post-container">
        <div class="row bordered-row row-bottom-padding">
            <?php get_template_part('templates/feature/featured-pages'); ?>
        </div>
        <div class="row bordered-row">
            <?php

            if (have_rows('related_pages')) {
                get_template_part('templates/feature/feature-square-row');
            }
            ?>


            <div class="feature-box height-match col-xs-12  col-sm-6 col-md-4">
                <?php the_field('left_content'); ?>
            </div>
            <div class="latest-news height-match col-xs-12 col-sm-6 col-md-4">
                <h3>Latest News</h3>
                <?php
                if (get_field('site', 'options') == 'athollestates') {
                    get_template_part('templates/news/latest-news');
                } else {
                    $latestNews = B2\AthollEstatesSite::latestNewsBlair();

                    if ($latestNews) {
                        echo $latestNews;
                    }
                }
                ?>
            </div>

            <div class="col-xs-12 height-match col-sm-6 col-md-4">
                <?php the_field('right_content'); ?>
            </div>
        </div>
    </div>

    <?php get_template_part('templates/panels/fw-panel');
}
?>


