<?php
/**
 * Template Name: Four by four grid
 */
?>
<div class="banner-wrapper">
    <?php
    $bannerMedia = get_field('banner_media');
    if ($bannerMedia == 'image') {
        get_template_part('templates/image/image-banner');
    } elseif ($bannerMedia == 'slider') {
        get_template_part('templates/slider/slider-banner');
        ?>

        <?php
    } elseif ($bannerMedia == 'video') {
        while (have_rows('banner_video_repeater')) {
            the_row();
            get_template_part('templates/video/video-banner');
        }
    }
    ?>
    <div class="banner-overlay">
            <div class="container">
                <div class="banner-container">        
                    <?php get_template_part('templates/page', 'header'); ?>
                    <?php if (get_field('banner_caption')){ ?>
                        <div class="banner-caption"><?= get_field('banner_caption') ?: ''; ?></div>
                    <?php } ?>  
                    <?php if (get_field('banner_button_link')){ ?>
                        <a href='<?= get_field('banner_button_link');?>'><div class="btn more-info-button"><?= get_field('banner_button_text');?></div></a>
                    <?php } ?>
                </div>
            </div>
        </div>
</div>
<div class="container post-container">
    <div class="row bordered-row">
        <?php
        $rpCount = count(get_field('related_pages'));
        if ($rpCount == 2) {
            $classSize = "col-md-6";
        } elseif ($rpCount == 3 || $rpCount == 5 || $rpCount == 6) {
            $classSize = "col-md-4";
        } elseif ($rpCount == 4 || $rpCount == 7 || $rpCount == 8) {
            $classSize = "col-md-3";
        }
        $count = 0;
        while (have_rows('related_pages')) {
            the_row();
            $colour = "ochre";
            $rpImg = get_sub_field('related_page_image');
            $rpImgAlt = get_post_meta($rpImg, '_wp_attachment_image_alt', true);
            $rpImg = $rpImg ? wp_get_attachment_image_src($rpImg, "small-4x3") : array("https://dummyimage.com/640x480/cccccc/000000.jpg&text=Pending+");
            $pageLink = get_sub_field('page_link') ? get_sub_field('page_link') : '';
        ?>
            <div class="feature-box height-match <?php echo $colour; ?> col-sm-6 <?php echo $classSize; ?>" itemscope itemtype="http://schema.org/Event">
                <div>
                    <a  itemprop="url" href="<?php echo $pageLink; ?>">
                        <img class="img-responsive" src="<?php echo $rpImg[0]; ?>" alt="<?php echo $rpImgAlt; ?>" title="<?php echo $rpImgAlt; ?>"/>
                    </a>
                    <h3 itemprop="title"><a  itemprop="url" href="<?php echo $pageLink; ?>"><?php the_sub_field('page_title'); ?></a></h3>
                    <p><?php the_sub_field('page_subtitle'); ?></p>
                </div>
            </div>
        <?php } ?>

        <div class="feature-box left-content col-xs-12 col-md-4">
            <?php the_field('left_content'); ?>
        </div>
        <div class="feature-box latest-news col-xs-12 col-md-4">
            <h3>Latest News</h3>
            <?php
            if (get_field('site', 'options') == 'athollestates') {
                get_template_part('templates/news/latest-news');
            } else {
                $latestNews = B2\AthollEstatesSite::latestNewsBlair();

                if ($latestNews) {
                    echo $latestNews;
                }
            }
            ?>
        </div>

        <div class="feature-box right-content col-xs-12 col-sm-6 col-md-4">
            <?php the_field('right_content'); ?>
        </div>
    </div>
</div>

<?php get_template_part('templates/panels/fw-panel'); ?>


