<header class="banner portal new-menu" itemscope itemtype="http://schema.org/WPHeader">
    <div class="wrap">
        <div class="container-fluid">
            <div class="row">
                <nav class="nav-top">
                    <a href="#" class="fa fa-angle-down circle-border visible-xs visible-sm visible-md navTopTrigger"></a>
                    <?php
                    if (has_nav_menu('top_navigation')) {
                        wp_nav_menu(['theme_location' => 'top_navigation', 'menu_class' => 'nav navbar-nav']);
                    }
                    ?>
                </nav>
            </div>
            <div class="row fixed-menu-row">
                <div class="container">
                    <div class="row flex-row">
                        <div class="col-sm-3 col-xl-2 logo-container logo-portal">
                            <a class="brand" href="<?php echo esc_url(home_url('/')); ?>">
                                <img itemscope itemtype="http://schema.org/ImageObject" class="img-responsive" itemprop="contentUrl" src="<?php echo \Roots\Sage\Assets\asset_path('images/logos/logo.png'); ?>" alt="<?php bloginfo('name'); ?>" title="<?php bloginfo('name'); ?>">
                                <img itemscope itemtype="http://schema.org/ImageObject" class="img-responsive mini" itemprop="contentUrl" src="<?php echo \Roots\Sage\Assets\asset_path('images/logos/logo-mini.png'); ?>" alt="<?php bloginfo('name'); ?>" title="<?php bloginfo('name'); ?>">
                            </a>
                        </div>                        
                        <div class="header-links-container col-xs-12 col-sm-9 col-xl-10">
                            <div class="nav-extra">
                                <ul class="nav navbar-nav" itemscope itemtype="http://schema.org/SiteNavigationElement">                                    
                                    <li><a href="/events/" title="Online Shop"><span class="hidden-sm">Online Shop</span></a></li>
                                    <li><a href="https://atholl-estates.co.uk/media-wall" title="View our media wall"><span class="hidden-sm">Social</span></a></li>
                                    <li><a href="https://atholl-estates.co.uk/latest-offers" title="View our latest offers"><span class="hidden-sm">Latest Offers</span></a></li>
                                    <li><a href="<?php echo $contactUrl; ?>" title="Contact"><span class="hidden-sm">Contact</span></a></li>
                                    <?php
                                        if (has_nav_menu('portal_navigation')) {
                                    ?>
                                        <li class="button-item"><button type="button" class="navbar-toggle push" data-toggle="push" data-target="#mainNav" aria-expanded="false"><i class="fa fa-bars"></i></button></li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if (has_nav_menu('portal_navigation')) { ?>

                    <div class="navbar-push" id="mainNav">
                        <div class="container">
                            <div class="row">
                                <nav class="nav-portal col-xs-12" itemscope itemtype="http://schema.org/SiteNavigationElement">
                                    <div class="social-splash-portal social-box col-xs-12">
                                        <ul class="nav navbar-nav social-splash social" itemscope itemtype="http://schema.org/SiteNavigationElement">
                                            <li><a href="<?php echo $homeUrl; ?>" title="Home" target="_blank"><i class="fa fa-home"></i></a></li>
                                            <li><a href="https://twitter.com/Blair_Castle" target="_blank"><i class="fa fa-twitter"></i></a></li>
                                            <li><a href="https://www.facebook.com/blaircastle" target="_blank"><i class="fa fa-facebook"></i></a></li>
                                            <li><a href="https://www.youtube.com/user/AthollEstates" target="_blank"><i class="fa fa-youtube-play"></i></a></li>
                                            <li><a href="mailto:office@blair-castle.co.uk" title="Email"><i class="fa fa-envelope"></i></a></li>
                                            <li><a href="http://atholl-estates.co.uk/sign-up/" title="Mailing list"><i class="fa fa-paper-plane"></i> <span class="hidden-xs hidden-sm">Mailing List</span></a></li>
                                            <?php if ($parentSlug == 'scottish-highland-castle') { ?>
                                                <li><a class="trip-logo" href="https://www.tripadvisor.co.uk/Attraction_Review-g946548-d318884-Reviews-Blair_Castle_and_Hercules_Gardens-Blair_Atholl_Perth_and_Kinross_Scotland.html" title="Tripadvisor"><img src="<?php echo get_template_directory_uri(); ?>/dist/images/logos/trip-large.png" /></a></li>
                                            <?php } elseif ($parentSlug == 'caravan-estate') { ?>
                                                <li><a class="trip-logo" href="https://www.tripadvisor.co.uk/Hotel_Review-g946548-d1134612-Reviews-Blair_Castle_Caravan_Park-Blair_Atholl_Perth_and_Kinross_Scotland.html" title="Tripadvisor"><img src="<?php echo get_template_directory_uri(); ?>/dist/images/logos/trip-large.png" /></a></li>
                                            <?php } ?>
                                            <li class="separator"></li>
                                            <li class="mobile-main-menu-item"><a href="/events/" title="<?= $whatsonText; ?>"><span class="hidden-lg"><?= $whatsonText; ?></span>Online Shop</a></li>
                                            <li class="mobile-main-menu-item"><a href="https://atholl-estates.co.uk/media-wall" title="View our media wall"><span class="hidden-lg">Social</span></a></li>
                                            <li class="mobile-main-menu-item"><a href="https://atholl-estates.co.uk/latest-offers" title="View our latest offers"><span class="hidden-lg">Latest Offers</span></a></li>
                                            <li class="mobile-main-menu-item"><a href="<?php echo $contactUrl; ?>" title="Contact"><span class="hidden-lg">Contact</span></a></li>
                                        </ul>
                                        <div class="social-box-line"></div>
                                    </div>
                                    <div class="social-splash-portal col-xs-12">
                                        <?php
                                        wp_nav_menu(['theme_location' => 'portal_navigation', 'menu_class' => 'nav navbar-nav']);
                                        ?>
                                    </div>
                                </nav>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</header>