<?php
/**
 * Template Name: Team Template
 */
?>
<div class="custom-team-template container">
    <div class="page-header">
        <h1>Team</h1>
    </div>
    <div class="row">
        <div class="col-sm-4 left-col-nav left-nav">
            <?php
            global $post;
            if (!have_rows('banner_image_repeater')) {
                $childSibMenu = B2\AthollEstatesSite::childSibMenu($post);
                if ($childSibMenu) {
                    ?>
                    <p class="dropNavTrigger"><?php _e('In this section'); ?><span class="fa fa-chevron-right visible-xs"></span></p>
                    <?= $childSibMenu; ?>
                <?php }
            }
            ?>
        </div>
        <div class="col-lg-8">
            <?php if( have_rows('team_row') ) { ?>
                <div class="team-output">
                    <?php while ( have_rows('team_row') ) {
                        the_row();

                        $line = get_sub_field('include_border_below_row') ? ' has-line' : '';

                        ?>
                        <div class="row-holder<?= $line; ?>">
                            <?php if( have_rows('team_members') ) { ?>
                                <?php while ( have_rows('team_members') ) {
                                    the_row();

                                    $color = get_sub_field('border_colour');
                                    ?>
                                    <div class="individual-member">
                                        <div class="img-area border-<?= $color; ?>">
                                            <?php if(get_sub_field('team_member_image')) { ?>
                                                <?php if(get_sub_field('team_member_link')) { ?><a href="<?php the_sub_field('team_member_link') ?>"><?php } ?>
                                                    <img src="<?php the_sub_field('team_member_image'); ?>" alt="<?php the_sub_field('team_member_name'); ?>">
                                                <?php if(get_sub_field('team_member_link')) { ?></a><?php } ?>
                                            <?php } ?>
                                        </div>
                                        <h2><?php the_sub_field('team_member_name'); ?></h2>
                                        <h3><?php the_sub_field('team_member_job_title'); ?></h3>
                                    </div>
                                <?php } ?>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
