<?php
/**
 * Template Name: No navigation template
 */
?>
<div class="container post-container">
    <?php get_template_part('templates/page-header'); ?>

    <?php
    if (have_rows('banner_image_repeater')) { ?>
        <?php if (!post_password_required($post)) { ?>

            <div class="row">
                <div class="col-sm-4 left-col-nav left-nav">
                    <div data-mh="navBanner" class="leftmenu-wrapper left-nav-border" style="background-image:url('<?php the_field('menu_background'); ?>');">
                        <?php if (get_field('left_column')) { ?>
                            <div class="left-ctn">
                                <?php the_field('left_column'); ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="thumb-pager">
                    </div>

                    <div data-mh="navBanner">
                        <div class="flexslider-w-thumb-pager">
                            <ul class="slides">
                                <?php
                                while (have_rows('banner_image_repeater')) {
                                    the_row();
                                    $bannerImg = get_sub_field('banner_image');
                                    $bannerImgAlt = get_post_meta($bannerImg, '_wp_attachment_image_alt', true);
                                    $tinyImg = $bannerImg ? wp_get_attachment_image_src($bannerImg, "thumbnail") : array("http://placehold.it/50x50/7db832");
                                    $bannerImg = $bannerImg ? wp_get_attachment_image_src($bannerImg, "internal-banner") : array("https://dummyimage.com/950x528/cccccc/000000.jpg&text=Pending+");
                                    ?>
                                    <li data-thumb="<?php echo $tinyImg[0]; ?>"><img class="img-responsive" src="<?php echo $bannerImg[0]; ?>" alt="<?php echo $bannerImgAlt; ?>"
                                                                                     title="<?php echo $bannerImgAlt; ?>"/></li>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>

                </div>
            </div>
        <?php } ?>
    <?php } ?>
    <div class="row-b row">
        <?php if (!post_password_required($post)) { ?>
            <div class="col-sm-4 left-col-nav left-nav">
                <?php
                if (!have_rows('banner_image_repeater')) {
                    if (get_field('left_column')) { ?>
                        <p><?php the_field('left_column'); ?></p>
                    <?php }
                }
                ?>



                <?php
                if (get_field('google_maps')) {
                    get_template_part('templates/feature/google-maps');
                }
                ?>

                <?php
                if (have_rows('features_repeater')) {
                    get_template_part('templates/feature/feature-square-sidebar');
                }
                ?>

                <div class="block-wrapper">
                    <?php
                    if (have_rows('left_call_to_action')) {
                        while (have_rows('left_call_to_action')) {
                            the_row();
                            $leftImg = get_sub_field('left_cta_image');
                            $leftImageAlt = get_post_meta($leftImg, '_wp_attachment_image_alt', true);
                            $leftImg = $leftImg ? wp_get_attachment_image_src($leftImg, "small-4x3") : array("https://dummyimage.com/640x480/cccccc/000000.jpg&text=Pending+");
                            ?>
                            <div class="block">
                                <img class="img-responsive" src="<?php echo $leftImg[0]; ?>" alt="<?php echo $leftImageAlt; ?>" title="<?php echo $leftImageAlt; ?>"/>
                                <p><?php the_sub_field('left_cta_title'); ?></p>
                                <p class="text-center"><a class="btn btn-cta" href="<?php the_sub_field('left_cta_link'); ?>"><?php the_sub_field('left_cta_link_label'); ?></a></p>
                            </div>
                            <?php
                        }
                    }
                    if (get_field('tripadvisor')) {
                        get_template_part('templates/feature/tripadvisor');
                    }
                    ?>
                </div>


            </div>

        <?php } ?>
        <div class="col-sm-8">
            <div class="row ">
                <div class="col-sm-12 the-content cms">
                    <?php the_content(); ?>
                </div>
            </div>
        </div>
    </div>
</div>