<?php
$images = get_field('gallery');
$size = 'full';
?>
<div class="custom-single-property">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 content-col col-lg-push-6">
                <div class="property-content">
                    <div class="property-heading">
                        <h1><?php the_title(); ?></h1>
                        <h2><?php the_field('address'); ?></h2>
                        <h3><?php the_field('price'); ?></h3>
                    </div>
                    <div class="property-ctas">
                        <?php if(get_field('phone')) { ?>
                            <div class="cta">
                                <a href="tel:<?php the_field('phone'); ?>">Call Us</a>
                            </div>
                        <?php }
                        if(get_field('email')) { ?>
                            <div class="cta">
                                <a href="mailto:<?php the_field('email'); ?>">Email Us</a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="property-body">
                        <?php the_field('more_information'); ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 carousel-col col-lg-pull-6">
                <div class="swiper-container gallery-top">
                    <div class="swiper-wrapper">
                        <?php if( $images ) { ?>
                            <?php foreach( $images as $image ){ ?>
                                <div class="swiper-slide" style="background-image:url('<?= $image['url']; ?>')"></div>
                            <?php } ?>
                        <?php } ?>
                    </div>
                    <!-- Add Arrows -->
                    <div class="swiper-button-next swiper-button-white"></div>
                    <div class="swiper-button-prev swiper-button-white"></div>
                </div>
                <div class="swiper-container gallery-thumbs">
                    <div class="swiper-wrapper">
                        <?php if( $images ) { ?>
                            <?php foreach( $images as $image ){ ?>
                                <div class="swiper-slide custom-thumb" style="background-image:url('<?= $image['url']; ?>')"></div>
                            <?php } ?>
                        <?php } ?>
                    </div>
                </div>
                <?php if(have_rows('property_statistics')) { ?>
                    <ul class="property-stats">
                        <?php while (have_rows('property_statistics')) {
                            the_row(); ?>
                            <li><?php the_sub_field('property_stat'); ?></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
        </div>
        <?php if(get_field('location')) {
            $location = get_field('location');
            ?>
            <div class="row">
                <div id="property-map" data-lat="<?= $location['lat']; ?>" data-lng="<?= $location['lng']; ?>">

                </div>
            </div>
        <?php } ?>
    </div>
</div>
