<?php
/**
 * Sage includes
 *
 * The $sage_includes array determines the code library included in your theme.
 * Add or remove files to the array as needed. Supports child theme overrides.
 *
 * Please note that missing files will produce a fatal error.
 *
 * @link https://github.com/roots/sage/pull/1042
 */
$sage_includes = [
  'lib/assets.php',    // Scripts and stylesheets
  'lib/extras.php',    // Custom functions
  'lib/setup.php',     // Theme setup
  'lib/titles.php',    // Page titles
  'lib/wrapper.php',   // Theme wrapper class
  'lib/customizer.php' // Theme customizer
];

foreach ($sage_includes as $file) {
  if (!$filepath = locate_template($file)) {
    trigger_error(sprintf(__('Error locating %s for inclusion', 'sage'), $file), E_USER_ERROR);
  }

  require_once $filepath;
}
unset($file, $filepath);


// Return page tree
function theme_page_tree($this_page) {
	if( !$this_page->post_parent ) $pagelist = wp_list_pages('title_li=&child_of='.$this_page->ID.'&echo=0');
	elseif( $this_page->ancestors ) {
		// get the top ID of this page. Page ids DESC so top level ID is the last one
		$ancestor = end($this_page->ancestors);
		$pagelist = wp_list_pages('title_li=&include='.$ancestor.'&echo=0');
		$pagelist = str_replace('</li>', '', $pagelist);
		$pagelist .= '<ul>' . wp_list_pages('title_li=&child_of='.$ancestor.'&echo=0') .'</ul></li>';
	}
	return $pagelist;
}


function show_category_posts( $query ) {
	if ( $query->is_blog() && $query->is_main_query() ) {
		$query->set( 'category_name', 'blog' );
	}
}
add_action( 'pre_get_posts', 'show_category_posts' );

add_filter( 'ninja_forms_admin_parent_menu_capabilities', 'custom_nf_capabilities' );
add_filter( 'ninja_forms_admin_all_forms_capabilities', 'custom_nf_capabilities' );

function custom_nf_capabilities( $cap ) {
    return 'edit_others_pages'; // Set desired user capability
}



add_action('init', 'covid_cookie');

function covid_cookie(){
	if(!isset($_COOKIE['covid-cookie'])) {
		$path = parse_url(get_option('siteurl'), PHP_URL_PATH);
		$host = parse_url(get_option('siteurl'), PHP_URL_HOST);
		$expiry = strtotime('+1 day');
		setcookie('covid-cookie', 1, $expiry, '/', $host);
	}
}
