<?php
if (have_rows('featured_events_repeater', 'options')) {
    $count = 0;
    while (have_rows('featured_events_repeater', 'options')) {

        the_row();
        $event = get_sub_field('featured_event');
        $count++;
        $line = $count % 2 == 0 ? 'split-line' : '';
        ?>
        <div class="col-sm-6 <?php echo $line; ?>">
            <article <?php post_class(); ?> itemscope itemtype="http://schema.org/Event">
                <div class="event-img col-sm-7">
                    <?php
                    $featImage = wp_get_attachment_image_src(get_post_thumbnail_id($event), "small-16x9") ? wp_get_attachment_image_src(get_post_thumbnail_id($event), "small-16x9") : array("http://placehold.it/704x396");
                    $featImgAlt = get_post_meta(get_post_thumbnail_id($event), '_wp_attachment_image_alt', true);
                    ?>

                    <a href="<?php the_permalink($event); ?>" title="<?php the_title_attribute($event); ?>">
                        <img class="img-responsive news-thumb" itemscope itemtype="http://schema.org/ImageObject" itemprop="contentUrl" src="<?php echo $featImage[0]; ?>" alt="<?php echo $featImgAlt; ?>" title="<?php echo $featImgAlt; ?>"/>
                    </a>
                    <div class="dates">
                        <?php
//                        $dateStart = get_field('event_start_date', $event);
//                        $dateEnd = get_field('event_end_date', $event);
                       $dateStart = get_post_meta($event, 'b2_event_start_date');
                        $dateEnd = get_post_meta($event, 'b2_event_end_date');

                        if ($dateStart) {
                            $dStart = date("d/m/Y", strtotime($dateStart[0]));
                            $dateArray = explode('/', $dStart);
                            $theDay = $dateArray[0];
                            $theMonth = $dateArray[1];
                            $dateObj = DateTime::createFromFormat('!m', $theMonth);
                            $monthName = '<span>' . $dateObj->format('M') . '</span>';
                            ?>
                            <span class="date-circle" itemprop="startDate"><?php echo $theDay . $monthName ?></span>
                            <?php
                        }
                        if ($dateEnd && $dateEnd[0] != "19700101" && $dateEnd[0] != $dateStart[0]) {
                            $dEnd = date("d/m/Y", strtotime($dateEnd[0]));
                            $dateArray = explode('/', $dEnd);
                            $theDay = $dateArray[0];
                            $theMonth = $dateArray[1];
                            $dateObj = DateTime::createFromFormat('!m', $theMonth);
                            $monthName = '<span>' . $dateObj->format('M') . '</span>';
                            ?>
                            <span class="date-circle" itemprop="endDate"><?php echo $theDay . $monthName ?></span>
                            <?php
                        }
                        $repeats = get_field('repeats', $event);
                        if ($repeats != 'never') {
                            ?>
                            <span class="more-dates-circle">More dates</span>
                        <?php } ?>

                    </div>
                </div>
                <div class="event-text col-sm-5">
                    <header>
                        <h2 class="entry-title" itemprop="name"><a href="<?php the_permalink($event); ?>"><?php echo get_the_title($event); ?></a></h2>
                    </header>
                    <div class="entry-summary" itemprop="description">
                        <?php
                        $postLink = '<a class="viewmore" href="' . get_permalink($event) . '">View Event </a>';
                        echo wp_trim_words(get_post_field('post_content', $event), 12, $postLink);
                        ?>
                    </div>

                </div>
            </article>
        </div>
        <?php
    }
}
?>