<div class="container">
<?php use Roots\Sage\Titles; ?>

    <div class="page-header">
      <h1>What's On</h1>
      <p class="subheading">Events at Blair Castle</p>
    </div>
</div>

<div class="container post-container">
    <div class="row bordered-row">
            <div class='col-sm-3 left-col'>
              <?php 
                    $category = get_the_category();
                    $catParID = $category[0]->category_parent;
                    $catParentName = get_cat_name ($catParID);
                    $catParentLink = get_category_link($catParID);
                    $catParentSlug= get_category($catParID)->slug;
                 
                    
                    $this_cat = (get_query_var('cat')) ? get_query_var('cat') : 1; 
                    $this_category = get_category($this_cat);
                    if ( $this_category->term_taxonomy_id ) { 
                        $this_cat = $this_category->term_taxonomy_id;    
                    } 
                    
                    $cats = get_categories('child_of=' . $this_cat . '');
                    echo '<p class="dropNavTrigger">Filter by Category <span class="fa fa-chevron-right visible-xs"></span></p>';
                    echo '<div class="nav"><ul id="mixFilters">';
                    echo '<li class="filter" data-filter=".'.$catParentSlug.'"><a href="'.$catParentLink.'">All '.$catParentName.'<strong> ('.$wp_query->found_posts.')</strong></a></li>';
                    foreach ( $cats as $category ) {
                        printf( '<li  class="filter" data-filter=".'.strtolower($category->slug).'"><a href="%1$s">%2$s</a></li>',
                        esc_url( get_category_link( $category->term_id ) ),
                        esc_html( $category->name )
                        );
                    }
                    echo '</ul></div>';
                    
                ?>
            </div>
            <div class="events-col col-sm-6" id="mixContainer">
                <?php if (!have_posts()) : ?>
                  <div class="alert alert-warning">
                    <?php _e('Sorry, no results were found.', 'sage'); ?>
                  </div>
                  <?php get_search_form(); ?>
                <?php endif; ?>
                <?php while (have_posts()) : the_post(); ?>
                <?php 
                        $cats='';//strtolower(wp_strip_all_tags(get_the_category_list(' ')));
                        foreach(get_the_category() as $category) {
                            $cats.= $category->slug . ' ';
                        } 
                    ?>
                        <div class="event-container mix <?php echo $cats; ?>">
                            <?php get_template_part('templates/content', 'category-event'); ?>
                    </div>
                <?php endwhile; ?>
            </div>
            <div class="right-col col-sm-3">
                calendar
            </div>
            <?php the_posts_navigation(); ?>
        
    </div>
</div>