<?php
$site = B2\ArchieSite::archieSite();
?>
<div class="container-fluid">
    <div class="row">
        <div class="contact-footer <?php echo $site; ?>">
            <div class="contact-area">
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-2">
                            <p class="square-block">Get in touch</p>
                        </div>
                        <div class="col-md-10">
                            <div class="contact-details">
                                <?php $siteObj = get_page_by_path($site); ?>
                                <a href="mailto:<?php the_field('email', $siteObj->ID) ?>"><?php the_field('email', $siteObj->ID) ?></a>
                                <br/>
                                <a href="tel:<?php the_field('phone_number', $siteObj->ID) ?>"><?php the_field('phone_number', $siteObj->ID) ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-2">
                            <p class="square-block">Stay connected</p>
                        </div>
                        <div class="col-md-5">
                            <div class="follow">
                                <p>Follow us online:</p>
                                <a target="_blank" href="<?php the_field('facebook', $siteObj->ID) ?>"><span class="fa fa-facebook"></span></a>
                                <a target="_blank" href="<?php the_field('twitter', $siteObj->ID) ?>"><span class="fa fa-twitter"></span></a>
                                <a target="_blank" href="<?php the_field('youtube', $siteObj->ID) ?>"><span class="fa fa-youtube-play"></span></a>
                                <a target="_blank" href="<?php the_field('instagram', $siteObj->ID) ?>"><span class="fa fa-instagram"></span></a>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="newsletter">
                                <p>Sign up to our newsletter:</p>
                                <input class="newsletter-signup" placeholder="<?php the_field('email', $siteObj->ID) ?>"/>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>