<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB0qsHf3R5GlGd5w2xeSo_BYpT35GLdj8o"></script>
<?php
$site = wp_get_post_terms(get_the_ID(), 'site_category');
$site = $site[0]->slug;
$location = get_field('event_location');
?>
<div class="container">
    <?php while (have_posts()) : the_post(); ?>
        <article <?php post_class(); ?>>
            <div class="row">

                <div class="col-md-12">
                    <header>
                        <h1 class="entry-title"><?php the_title(); ?></h1>
                        <?php get_template_part('templates/entry-meta'); ?>
                    </header>
                </div>

                <div class="col-md-8">
                    <div class="entry-content">
                        <?php the_content(); ?>
                        <h3>Event Details:</h3>
                        <?php the_field('event_details'); ?>
                    </div>
                    <?php
                    if (!empty($location)):
                        ?>
                        <div class="acf-map">
                            <div class="marker" data-lat="<?php echo $location['lat']; ?>" data-lng="<?php echo $location['lng']; ?>"></div>
                        </div>
                    <?php endif; ?>

                </div>
                <div class="col-md-4">
                    <div class="event-side">
                        <?php the_post_thumbnail(); ?>
                        <?php if (get_field('external_link')) { ?>
                            <div class="home-button <?php echo $site ?>-btn">
                                <a target="_blank" href="<?php the_field('external_link'); ?>">more...</a>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="form-side">
                        <?php
                        $form = get_field('form_embed');
                        echo do_shortcode($form);
                        ?>
                    </div>
                </div>

            </div>
        </article>
    <?php endwhile; ?>
</div>