<?php
/**
 * Sage includes
 *
 * The $sage_includes array determines the code library included in your theme.
 * Add or remove files to the array as needed. Supports child theme overrides.
 *
 * Please note that missing files will produce a fatal error.
 *
 * @link https://github.com/roots/sage/pull/1042
 */
$sage_includes = [
  'lib/assets.php',    // Scripts and stylesheets
  'lib/extras.php',    // Custom functions
  'lib/setup.php',     // Theme setup
  'lib/titles.php',    // Page titles
  'lib/wrapper.php',   // Theme wrapper class
  'lib/customizer.php' // Theme customizer
];

foreach ($sage_includes as $file) {
  if (!$filepath = locate_template($file)) {
    trigger_error(sprintf(__('Error locating %s for inclusion', 'sage'), $file), E_USER_ERROR);
  }

  require_once $filepath;
}
unset($file, $filepath);


function custom_excerpt_length($length) {
    global $post;
    if ($post->post_type == 'post') {
        return 32;
    } elseif ($post->post_type == 'events') {
        return 65;
    } elseif ($post->post_type == 'people') {
        return 75;
    }
}
add_filter('excerpt_length', 'custom_excerpt_length');

add_theme_support( 'post-thumbnails' );
add_image_size( 'square-thumb', 250, 250, true );