<div class="container custom-news">
    <div class="row">
        <div class="col-md-8">
            <div class="news-info">
                <?php the_field('news_introduction', 'option'); ?>
            </div>
            <?php
            if ( have_posts() ) {
                while ( have_posts() ) {
                    the_post();

                    $featuredImage = get_the_post_thumbnail_url(get_the_id(), 'thumbnail');
                    ?>

                    <div class="news-item">
                        <div class="row row-eq-height">
                            <div class="col-md-9 content-col">
                                <h2><?php the_title(); ?></h2>
                                <div class="date"><?php the_date(); ?></div>
                                <div class="excerpt"><?php the_excerpt(); ?></div>
                            </div>
                            <div class="col-xs-12 col-md-3 image-col">
                                <?php if($featuredImage) { ?>
                                    <div class="image-holder">
                                        <?= file_get_contents(get_template_directory_uri() . '/dist/images/new-assets/circle-device-behind-card-image.svg'); ?>
                                        <img src="<?= $featuredImage; ?>" alt="<?php the_title(); ?>">
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>


                <?php } wp_reset_postdata();
            } // end if
            ?>
        </div>
        <div class="col-md-4">
            <div class="widget-holder">
                <h2>View articles in:</h2>
                <?php
                $category = get_the_category();
                $categories = get_categories(['parent' => $category[0]->term_id, 'hide_empty' => false]);
                if($categories) { ?>
                    <div class="widget widget_categories"><h2 class="widgettitle">Categories</h2>
                        <ul>
                            <?php foreach($categories as $cat) { ?>
                            <li class="cat-item cat-item-120"><a href="<?= get_category_link($cat->term_id) ?>"><?= $cat->name; ?></a>
                                <?php }  ?>
                        </ul>
                    </div>
                <?php } else {
                    the_widget('WP_Widget_Categories');
                } ?>
            </div>
        </div>
    </div>
</div>
