<?php
$phone = get_field('phone_number', 'option');
$email = get_field('email_address', 'option');
?>
<header class="banner">
    <div class="top-bar">
        <div class="container">
            <div class="top-bar-inner">

                <div class="primary-holder">
                    <?php if($phone) { ?>
                        <div class="phone contact-item">
                            <?= file_get_contents(get_template_directory_uri() . '/dist/images/new-assets/call.svg'); ?>
                            <a href="tel:<?= $phone; ?>"><?= $phone; ?></a>
                        </div>
                    <?php } ?>
                    <?php if($email) { ?>
                        <div class="email  contact-item">
                            <?= file_get_contents(get_template_directory_uri() . '/dist/images/new-assets/email.svg'); ?>
                            <a href="mailto:<?= $email; ?>"><?= $email; ?></a>
                        </div>
                    <?php } ?>
                </div>

                <div class="secondary-holder">
                    <?php
                    $globalSocials = get_field('global_socials', 'option');
                    if($globalSocials) { ?>
                        <div class="social-links">
                            <?php
                            foreach($globalSocials as $social) { ?>
                                <a target="_blank" href="<?= $social['url'] ?>">
                    <span class="fa-stack">
                      <i class="fa fa-circle fa-stack-2x"></i>
                      <i class="fa <?= $social['fontawesome_code']; ?> fa-stack-1x fa-inverse"></i>
                    </span>
                                </a>
                            <?php } ?>
                        </div>
                    <?php } ?>

                    <nav class="nav-top">
                        <?php
                        if (has_nav_menu('top_bar_navigation')) :
                            wp_nav_menu(['theme_location' => 'top_bar_navigation', 'menu_class' => '']);
                        endif;
                        ?>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <div class="site-headers">
        <div class="container">
            <div class="main-nav-holder">
                <div class="left-holder">
                    <a class="brand" href="<?= esc_url(home_url()); ?>">
                        <img src="<?= get_template_directory_uri() . '/dist/images/new-assets/archie-foundation-logo.png'; ?>">
                    </a>
                </div>
                <div class="right-holder">
                    <button type="button" class="navbar-toggle pushnav-toggle visible-xs visible-sm" data-target="#primary-nav">
                        <span class="sr-only">Toggle navigation</span>
                        <i class="fa fa-bars" aria-hidden="true"></i>
                    </button>
                    <div class="nav-wrapper">
                        <nav class="nav-primary header-menu">
                            <?php
                            if (has_nav_menu('primary_navigation')) :
                                wp_nav_menu(['theme_location' => 'primary_navigation', 'menu_class' => '']);
                            endif;
                            ?>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
