<div class="container">
    <?php

    $terms = get_terms('tags');
    $people = array();
    foreach ($terms as $term) {
        $termOrder = get_field('order', $term);
        $people[$termOrder] = $term;
    }

    krsort($people, SORT_NUMERIC);
    foreach ($people as $termOrder => $term) {

        ?>
        <div class="row">

            <h1 class="col-md-12"><?php echo $term->name; ?></h1>

            <?php
            $term_id = $term->term_id;
            $term_link = get_term_link($term);
            $posts = get_posts(array(
                'post_type' => 'people',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'tags',
                        'field' => 'slug',
                        'terms' => $term->slug
                    )
                ),
                'meta_key' => 'order',
                'orderbt' => 'meta_value',
                'order' => 'ASC',
                'numberposts' => -1
            ));
            foreach ($posts as $post) {
                $checkFundraiser = get_the_terms(get_the_ID(), 'tags');
                $checkFundraiser = $checkFundraiser[0]->slug;
                if ($checkFundraiser == 'chief-executives-office') {
                    get_template_part('templates/content-fundraiser');
                } else {
                    get_template_part('templates/content-person');
                }
            } ?>
        </div>
    <?php } ?>
</div>
