
<div class="featured-pages">
    <div class="container">
        <?php
        $posts = get_sub_field('featured_pages');
        $title  = get_sub_field('featured_pages_title');

        if($title) { ?>
            <div class="col-lg-12 text-center">
                <h3 class="featured-pages-title"><?= $title; ?></h3>
            </div>
        <?php } ?>

        <?php if ($posts): ?>
            <?php foreach ($posts as $post): ?>
                <div class="col-md-6 col-lg-4 featured-page-col">
                    <?php setup_postdata($post); ?>
                    <div class="featured-block">
                        <a href="<?php the_permalink(); ?>">
                            <div class="img-block">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('medium');
                                } else { ?>
                                    <img class="img-responsive img-page-link wp-post-image" src="https://d1ssu070pg2v9i.cloudfront.net/pex/archie/2018/04/03121612/Archie-80.jpg" />
                                <?php } ?>
                            </div>
                        </a>
                        <div class="page-content">
                            <a href="<?php the_permalink(); ?>">
                                <h2><?php the_title(); ?></h2>
                            </a>
                            <div class="description">
                                <?php if (!empty(get_the_content())) { ?>
                                    <p><?php echo wp_trim_words(apply_filters('the_content', $post->post_content), 15); ?></p>
                                <?php } else { ?>
                                    <p><?php the_field('post_excerpt'); ?></p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            <?php wp_reset_postdata(); ?>
        <?php endif; ?>
    </div>
</div>
