<?php
$blocks = get_sub_field('blocks');

$blocksPerRow = get_sub_field('blocks_per_row') == 3 ? 'col-sm-6 col-lg-4' : 'col-sm-6 col-lg-3';
$blocksContainer = get_sub_field('container_size') == 'full' ? 'container-fluid' : 'container';
$useBorder = get_sub_field('use_border') ? 'use-border' : 'no-border';


if($blocks) { ?>
    <div class="custom-blocks <?= $useBorder; ?>">
        <div class="<?= $blocksContainer; ?>">
            <div class="row">
                <?php foreach($blocks as $block) { ?>
                    <div class="block-col <?= $blocksPerRow; ?>">
                        <div class="block">
                            <a href="<?= $block['link']['url']; ?>">
                                <div class="image-holder">
                                    <img src="<?= $block['image']['url']; ?>" alt="<?= $block['title']; ?>">
                                    <div class="card-prompt">
                                        <div class="holder">
                                            <?= file_get_contents(get_template_directory_uri() . '/dist/images/new-assets/image-masks/card-prompt.svg'); ?>
                                            <span class="fa fa-angle-right"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="content-holder">
                                    <h3><?= $block['title']; ?></h3>
                                </div>
                            </a>
                        </div>
                    </div>

                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
