<?php

$rows = get_field('hero_banners');
if ($rows) { ?>
    <div class="site-sliders">
        <img src="<?= get_template_directory_uri() . '/dist/images/new-assets/sketch-border-upper.png'; ?>" class="top-slide-img">
        <ul class="slides">
            <?php if ($rows) {
                foreach ($rows as $row) {
                    $image = wp_get_attachment_image_url($row['image'], 'full');
                    ?>
                    <li>
                        <div class="slide-content">
                            <div class="container">
                                <div class="row row-eq-height">
                                    <div class="col-lg-6 slide-info-col">
                                        <div class="slide-info">
                                            <h2><?= $row['title']; ?></h2>
                                            <div class="description"><?= $row['content']; ?></div>
                                            <?php if($row['button_link']){?>
                                                <div class="slide-button">
                                                    <a href="<?= $row['button_link'] ?>"><?= $row['button_text'] ?></a>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-6  slide-image-col">
                                        <div class="slide-image">
                                            <img src="<?= $image; ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                <?php }
            } ?>
        </ul>
        <img src="<?= get_template_directory_uri() . '/dist/images/new-assets/sketch-border-lower.png'; ?>" class="bottom-slide-img">
        <?php if (count($rows) > 1) { ?>
            <div class="nav-controls">
                <div class="container">
                    <a href="#" class="flex-prev flex-nav-item">
                        <?= file_get_contents(get_template_directory_uri() . '/dist/images/new-assets/control-left.svg'); ?>
                        <span class="fa fa-angle-left"></span>
                    </a>
                    <a href="#" class="flex-next flex-nav-item">
                        <?= file_get_contents(get_template_directory_uri() . '/dist/images/new-assets/control-left.svg'); ?>
                        <span class="fa fa-angle-right"></span>
                    </a>
                </div>
            </div>
        <?php } ?>
    </div>

<?php } ?>
