<?php
if (get_field('feature_events') == true) {
    $backgroundImg = wp_get_attachment_image_url(get_field('background_image_events', 'options'), 'full'); ?>
    <?php
    $site = get_field_object('site_theme');

    $meta_query = array(
        array(
            'key' => 'event_date',
            'value' => date('Ymd'),
            'type' => 'DATE',
            'compare' => '>='
        )
    );

    $the_query = new WP_Query(array(
        'post_type' => 'events',
        'posts_per_page' => 2,
        'orderby' => 'meta_value_num',
        'meta_key' => 'event_date',
        'order'	=> 'ASC',
        'meta_query' => $meta_query,
        'tax_query' => array(
            array(
                'taxonomy' => 'site_category',
                'field' => 'slug',
                'terms' => $site['value'],
            )
        ),
    ));
    ?>
    <?php if ($the_query->have_posts()) { ?>
        <div class="featured-events col-md-12" style="background-image:url('<?php echo $backgroundImg ?>');">
            <div class="container">
                <div class="row">
                    <?php
                    while ($the_query->have_posts()) : $the_query->the_post();
                        get_template_part('templates/events/content-events');
                    endwhile;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
        </div>
    <?php }
}
