<?php
$site = B2\ArchieSite::archieSite();
$backgroundImg = wp_get_attachment_image_url(get_sub_field('background_image'), 'full');

?>
<div class="content-hero-block">
    <div class="container">
        <div class="row">
            <div class="col-lg-5">
                <?php
                the_sub_field('content_area');
                $posts = get_sub_field('call_to_actions');
                if ($posts): ?>
                    <div class="block-buttons">
                        <div class="animal">
                            <div class="inner">
                                <img src="<?= get_template_directory_uri() . '/dist/images/new-assets/animals/archie-bear.png'; ?>" class="bear">
                            </div>
                        </div>
                        <div class="inner">
                            <?php foreach ($posts as $post):
                                setup_postdata($post); ?>
                                <div class="hero-block-button">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </div>
                                <?php wp_reset_postdata();
                            endforeach; ?>
                        </div>
                        <div class="animal">
                            <div class="inner">
                                <img src="<?= get_template_directory_uri() . '/dist/images/new-assets/animals/archie-giraffe.png'; ?>" class="giraffe">
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-lg-offset-1 col-lg-6 video-col">
                <div class="inner-video">
                    <div class="video-wrapper">
                        <?php the_sub_field('video'); ?>
                    </div>
                </div>
                <div class="yt-info-holder">
                    <h3>&#9658; <?php the_sub_field('video_title'); ?></h3>
                    <div class="youtube"><a href="https://www.youtube.com/channel/UC_KKm1X_H7hrUu5FqWD7qwQ"><i class="fa fa-youtube-play"></i> More on Youtube</a></div>
                </div>

            </div>
        </div>
    </div>
    <?= file_get_contents(get_template_directory_uri() . '/dist/images/new-assets/bakground-paint-lines.svg'); ?>
</div>
