<?php

if (is_singular('post')) {
    $site = get_the_category();
    $site = $site[0]->slug;
} elseif (is_singular('events')) {
    $site = wp_get_post_terms(get_the_ID(), 'site_category');
    $site = $site[0]->slug;
} elseif (is_singular('people')) {
    $site = wp_get_post_terms(get_the_ID(), 'site_theme');
    $site = $site[0]->slug;
} else {
    $site = B2\ArchieSite::archieSite();
}
?>

<?php if (!is_post_type_archive('product') && !is_singular('product')) { ?>
    <div class="site-headers">
        <div class="<?php echo $site; ?>">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-2 no-padding sitelogo">
                        <a class="brand" href="<?= esc_url(home_url('/' . $site)); ?>">
                            <?php if ($site == 'archie-fairy-box') { ?>
                                <img src="<?php echo get_template_directory_uri(); ?>/dist/images/archie-logo-white-text.png">
                            <?php } elseif ($site == 'archie-cafe') { ?>
                                <img class="cafe-logo" src="<?php echo get_template_directory_uri(); ?>/dist/images/cafe.png">
                            <?php } elseif ($site == 'friends-of-the-neonatal-unit') { ?>
                                <img class="cafe-logo" src="<?php echo get_template_directory_uri(); ?>/dist/images/neonatal-trans.png">
                            <?php } else { ?>
                                <img src="<?php echo get_template_directory_uri(); ?>/dist/images/archie-logo.png">
                            <?php } ?>
                        </a>
                    </div>
                    <div class="col-md-10 no-padding">
                        <button type="button" class="navbar-toggle pushnav-toggle visible-xs visible-sm" data-target="#primary-nav">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <div class="nav-wrapper <?php echo $site ?>">
                            <nav class="nav-primary header-menu col-md-12">
                                <?php
                                B2\ArchieSite::archieSiteMenu($site);
                                ?>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>