<?php $site = B2\ArchieSite::archieSite(); ?>
<div class="container">
    <div class="featured-pages internal-pages">
        <?php
        $posts = get_sub_field('featured_pages');
        if ($posts): ?>
            <div class="row">
                <?php foreach ($posts as $post): ?>
                    <div class="col-md-4 no-padding">
                        <?php setup_postdata($post); ?>
                        <div class="featured-block <?php echo $site; ?> <?php echo $site; ?>-featured-block">
                            <div class="img-block-internal">
                                <a href="<?php the_permalink(); ?>">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('medium', ['class' => 'img-responsive img-page-link']);
                                    } else { ?>
                                        <img class="img-responsive img-page-link" src="https://d1ssu070pg2v9i.cloudfront.net/pex/archie/2017/09/12154535/RACH_412.jpg"/>
                                    <?php } ?>
                                </a>
                            </div>
                            <div class="page-content-internal">
                                <a href="<?php the_permalink(); ?>">
                                    <h2><?php the_title(); ?></h2>
                                </a>
                                <?php if (!empty(get_the_content())) { ?>
                                    <p><?php echo wp_trim_words(apply_filters('the_content', $post->post_content), 15); ?></p>
                                <?php } else { ?>
                                    <p><?php the_field('post_excerpt'); ?></p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <?php wp_reset_postdata(); ?>
        <?php endif; ?>
    </div>
</div>