<?php
$site = B2\ArchieSite::archieSite();

$rows = get_field('hero_banners');
if ($rows) {
    ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12 no-padding">
                <div class="site-sliders">
                    <ul class="slides"> <?php
                        if ($rows) {
                            foreach ($rows as $row) {
                                $image = wp_get_attachment_image_url($row['image'], 'full');
                                ?>
                                <li>
                                    <div class="img-bg" style="background-image:url(<?php echo $image; ?>)">
                                        <div class="slide-content">
                                            <div class="slide-info col-md-5">
                                                <h1><?php echo $row['title']; ?></h1>
                                                <p><?php echo $row['content']; ?></p>
                                                <?php if($row['button_link']){?>
                                                <div class="btn home-button <?php echo $site; ?>-btn ">
                                                    <a href="<?php echo $row['button_link'] ?>"><?php echo $row['button_text'] ?></a>
                                                </div>
												<?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            <?php }
                        } ?>
                    </ul>
                </div>
                <?php if (count($rows) > 1) { ?>
                    <div class="nav-controls">
                        <a href="#" class="flex-prev"><span class="fa fa-angle-left"></span></a>
                        <a href="#" class="flex-next"><span class="fa fa-angle-right"></span></a>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
