<div class="container">
    <div class="row">

        <div class="col-md-12 events-intro">
            <?php the_content(); ?>
        </div>

        <?php $site = B2\ArchieSite::archieSite();

        $args = array(
            'post_type' => 'events',
            'posts_per_page' => -1,
            'tax_query' => array(
                array(
                    'taxonomy' => 'site_category',
                    'field' => 'slug',
                    'terms' => $site,
                ),
            ),
        );

        $query = new WP_Query($args);

        while ($query->have_posts()) : $query->the_post();

            $eventDate = get_field('event_date');
            $eventDate = strtotime($eventDate);

            $currentDate = date('M d, Y');
            $currentDate = strtotime($currentDate);

            $endDate = get_field('event_end_date');
            $endDate = strtotime($endDate);

            if (isset($eventDate) && $eventDate < $endDate ) {
                get_template_part('templates/content-events');
            } elseif (isset($eventDate) && $eventDate > $currentDate ) {
                get_template_part('templates/content-events');
            }
        endwhile;
        ?>
        <?php wp_reset_postdata(); ?>
    </div>
</div>
