<div class="custom-news-article">
    <div class="page-header-wrap">
        <div class="inner-page-header">
            <img src="<?= get_template_directory_uri() . '/dist/images/new-assets/sketch-border-upper.png'; ?>" class="top-slide-img">
            <div class="container">
                <h2> Blog and Updates</h2>
            </div>
            <img src="<?= get_template_directory_uri() . '/dist/images/new-assets/sketch-border-lower.png'; ?>" class="bottom-slide-img">
        </div>
    </div>
    <div class="container">
        <?php while (have_posts()) : the_post(); ?>
            <article <?php post_class(); ?>>

                <?php $terms = get_the_terms(get_the_id(''), 'category'); ?>
                <div class="back-prompt">
                    <div class="holder">
                        <?= file_get_contents(get_template_directory_uri() . '/dist/images/new-assets/image-masks/card-prompt.svg'); ?>
                        <span class="fa fa-angle-left"></span>
                    </div>
                    <?php if($terms && $terms[0]->slug !== 'uncategorized') { ?>
                        Back to Category:
                        <ul>
                            <?php foreach($terms as $term) { ?>
                                <li><a href="<?= get_category_link($term->term_id); ?>"><?= $term->name; ?></a></li>
                            <?php } ?>
                        </ul>
                    <?php } else { ?>
                        <a href="<?= get_permalink( get_option( 'page_for_posts' ) ); ?>">Back to news</a>
                    <?php } ?>
                </div>

                <div class="row">
                    <div class="entry-content col-md-7">
                        <h1 class="entry-title"><?php the_title(); ?></h1>
                        <strong><?php get_template_part('templates/entry-meta'); ?></strong>
                        <div class="description"><?php the_content(); ?></div>
                    </div>
                    <div class="col-md-offset-1 col-md-4">
                        <div class="widget-holder">
                            <?php if(get_the_post_thumbnail_url()) { ?>
                                <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>" class="widget-image">
                            <?php } ?>
                            <h2>View articles in:</h2>
                            <?php the_widget('WP_Widget_Categories'); ?>
                        </div>
                    </div>
                </div>
            </article>
        <?php endwhile; ?>
    </div>
</div>
