<?php
$homepageID = get_option( 'page_on_front' );
$carouselItems = get_field('course_carousel', $homepageID);
?>
<div class="container-slide">
    <div class="swiper-container">
        <div class="swiper-wrapper">
            <div class="fake-slide">
                <h2><?= get_field('carousel_title', $homepageID); ?></h2>
                <p class="quote"><?= get_field('carousel_quote', $homepageID); ?></p>
                <p class="name"><?= get_field('carousel_name', $homepageID); ?></p>
                <p class="job"><?= get_field('carousel_job_title', $homepageID); ?></p>
                <a class="twitter-link" target="_blank" href="https://twitter.com/amcofhe?lang=en"><i class="fab fa-twitter"></i>@AMCofHE</a>
            </div>
            <?php
            foreach ($carouselItems as $carouselItem) { ?>
                <?php $course = $carouselItem['course_link'][0]; ?>
                <a class="swiper-slide" href="<?= get_the_permalink($course->ID); ?>">
                    <div class="slide-wrap">
                        <?= $flag = ($carouselItem['flag_content'] ? '<span><i class="fas fa-caret-down"></i>' . $carouselItem["flag_content"] . '</span>' : ''); ?>
                        <div class="img-wrap"><?= get_the_post_thumbnail($course->ID, 'slider-image'); ?></div>
                        <div class="content-wrap">
                            <h2><?= wp_trim_words(get_the_title($course->ID), 5); ?></h2>
                            <p><?= wp_trim_words($course->post_content, 15); ?></p>
                        </div>
                    </div>
                </a>
            <?php } ?>
        </div>
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
    </div>
</div>
