<?php
$featuredBlocks = get_field('featured_menus');
if ($featuredBlocks) { ?>
    <div class="col-md-12">
        <div class="title-wrap">
            <h1 class="section-title "><?= get_field('title'); ?></h1>
            <h1 class="section-title "><?= get_field('secondary_title'); ?></h1>
        </div>
    </div>
    <?php foreach ($featuredBlocks as $featuredBlock) { ?>
        <div class="home-featured-menu">
            <div class="wrap">
                <div class="svg-overlay"></div>
                <div class="row">
                    <div class="content">
                        <h2><?= $featuredBlock['menu_title']; ?></h2>
                        <?php
                        $menuLinks = $featuredBlock['menu_links']; ?>
                        <ul>
                            <?php foreach ($menuLinks as $menuLink) { ?>
                                <li><a class="home-featured-block"
                                       href="<?= get_permalink($menuLink->ID); ?>"><?= get_the_title($menuLink->ID); ?></a>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                    <div class="featured-image"
                         style="background-image:url('<?= wp_get_attachment_image_url($featuredBlock['menu_image'], 'featured'); ?>')"></div>
                </div>
            </div>
        </div>
    <?php } ?>
<?php } ?>