<?php

namespace Blue2\Scruffy;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        add_image_size('home-featured-block', 350, 325, true);
        add_image_size('slider-image', 350, 160, true);
        add_image_size('featured-post-home', 380, 240, true);
        add_image_size('program-aims', 310, 260, true);
        add_image_size('course-block', 490, 355, true);
        add_image_size('full-width', 510, 380, true);
        add_image_size('blog', 245, 245, true);
        add_image_size('blog-header', 1200);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters()
    {
        add_filter('acf/fields/google_map/api', [$this, 'acfApiKey']);
        add_filter('category_template', [$this, 'changeSubCategoryTemplate']);
        add_filter( 'upload_mimes', [$this, 'almak_mime_types'], 1, 1 );
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'createOptionPages']);
        add_action('init', [$this, 'createStaffTaxonomy']);
        remove_action('wp_head', [$this, 'adjacent_posts_rel_link_wp_head'], 10);
        add_action('wp_head', [$this, 'trackPostViews']);

    }

    private function setupControllers()
    {
        //Empty
    }

    public static function customPagination()
    {
        global $wp_query;

        echo paginate_links([
            'base' => str_replace(99999999, '%#%', esc_url(get_pagenum_link(99999999))),
            'format' => '?paged=%#%',
            'current' => max(1, get_query_var('paged')),
            'total' => $wp_query->max_num_pages,
        ]);
    }

    function changeSubCategoryTemplate($template)
    {

        $category = get_queried_object();
        if ($category->parent == 9) {
            $template = locate_template('category-blog.php');
            return $template;
        } else {
            return $template;
        }
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'top_menu' => 'Top Menu',
            'course_menu' => 'Course Menu',
            'mobile_menu' => 'Mobile Menu',
            'mobile_menu_bottom' => 'Mobile Menu Bottom',
            'footer_one' => 'Footer Menu One',
            'footer_two' => 'Footer Menu Two',
            'footer_three' => 'Footer Menu Three',
            'footer_four' => 'Footer Menu Four',
            'footer_five' => 'Footer Menu Five',
        ]);
    }

    public function trackPostViews($postID)
    {
        if (!is_single()) {
            return;
        }
        if (empty ($postID)) {
            global $post;
            $postID = $post->ID;
        }
        self::countPostViews($postID);
    }

    public function countPostViews($postID)
    {
        $countKey = 'post_count';
        $count = get_post_meta($postID, $countKey, true);
        if ($count == '') {
            delete_post_meta($postID, $countKey);
            add_post_meta($postID, $countKey, '0');
        } else {
            $count++;
            update_post_meta($postID, $countKey, $count);
        }
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    public function registerPostTypes()
    {
        Post\Events::registerPostType();
        Post\Course::registerPostType();
        Post\Staff::registerPostType();
    }

    public function acfApiKey($api)
    {
        $api['key'] = 'AIzaSyAGsKZ5PP8iURMpB4kRQKcpLQps-szGeqw';
        return $api;

    }

    public function createOptionPages()
    {
        if (function_exists('acf_add_options_page')) {

            $option_page = acf_add_options_page([
                'page_title' => 'Staff Settings',
                'parent' => 'edit.php?post_type=staff',
                'capability' => 'edit_posts',
                'redirect' => false,
            ]);

        }
    }

    public function createStaffTaxonomy()
    {
        $labels = [
            'name' => _x('Staff Types', 'taxonomy general name', 'textdomain'),
            'singular_name' => _x('Staff Type', 'taxonomy singular name', 'textdomain'),
            'search_items' => __('Search Staff Types', 'textdomain'),
            'all_items' => __('All Staff Types', 'textdomain'),
            'parent_item' => __('Parent Staff Type', 'textdomain'),
            'parent_item_colon' => __('Parent Staff Type:', 'textdomain'),
            'edit_item' => __('Edit Staff Type', 'textdomain'),
            'update_item' => __('Update Staff Type', 'textdomain'),
            'add_new_item' => __('Add New Staff Type', 'textdomain'),
            'new_item_name' => __('New Staff Type', 'textdomain'),
            'menu_name' => __('Staff Type', 'textdomain'),
        ];

        $args = [
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'show_admin_column' => true,
            'query_var' => true,
            'rewrite' => ['slug' => 'staff-type'],
        ];

        register_taxonomy('staff-type', ['staff'], $args);
    }

    function almak_mime_types( $mime_types ) {
        $mime_types['cer'] = 'application/pkix-cert';     // Adding .cer extension
        
        return $mime_types;
    }

}
