<div class="sidebar staff order-2 order-lg-1">
    <div class="programme-aims">
        <div class="bg-sidebar-noslash"></div>
        <div class="content">
            <h2><?= get_field('staff_sidebar_title', 'option') ?></h2>
            <div class="sidebar-links">
                <?php
                $links = get_field('staff_page_links', 'option');
                global $wp_query;
                if($links) {
                    foreach ($links as $post) {
                        setup_postdata($post); ?>
                        <a href="<?php the_permalink(); ?>"
                           class="<?= $post->post_name == $wp_query->queried_object->post_name ? 'active' : ''; ?>"><?php the_title(); ?></a>
                    <?php }
                }
                wp_reset_postdata();
                ?>
            </div>
        </div>
    </div>

    <?php if (get_field('staff_feature_boxes', 'option') == true) {
        $blocks = get_field('staff_feature_boxes', 'option');
        foreach ($blocks as $block) {
                $image = wp_get_attachment_image($block['image'], 'medium'); ?>
                <article class="staff-box">
                    <div class="feature-content">
                        <h2><?= $block['title']; ?><span><?= $block['subtitle']; ?></span></h2>
                        <?= $block['content']; ?>
                        <a href="<?= $block['link']; ?>"><?= $block['link_text'] ?></a>
                        <?php if($image) {
                            echo $image;
                        } else { ?>
                            <img alt="Advanced Diploma Image" src="https://d1ssu070pg2v9i.cloudfront.net/pex/almcollege/2019/01/10164202/AdvanceDiploma.jpg" >
                        <?php } ?>
                    </div>
                </article>
            <?php }
    } ?>

    <?php if (get_field('staff_sidebar_link', 'option') == true) { ?>
        <a class="btn btn-apply" href="<?= get_field('staff_link_url', 'option'); ?>"><?= get_field('staff_link_title' , 'option'); ?></a>
    <?php } ?>
</div>
