<?php
$companyLogo = get_field('company_logo', 'option');
$companyLogo = wp_get_attachment_image_src($companyLogo, 'full');

$showBannerMessage = get_field('show_banner_message', 'option');
$bannerMessagePrefix = get_field('banner_message_prefix', 'option');
$bannerMessageLink = get_field('banner_message_link', 'option');
?>
<?php if ($showBannerMessage) {
    if (!isset($_COOKIE['alm-hidebanner'])) {
?>
        <div class="banner-message">
            <p class="container"><?= $bannerMessagePrefix; ?> <a href="<?= $bannerMessageLink['url'] ?>"><?= $bannerMessageLink['title'] ?></a><a class="banner-message__dismiss">x</a></p>
        </div>
<?php
    }
} ?>

<nav class="top-nav">
    <div class="contact-section">
        <a href="mailto:admissions@almcollege.ac.uk"><i class="far fa-envelope"></i></a>
        <a href="/visit-us/maps-directions/"><i class="fas fa-map-marker-alt"></i></a>
        <a href="#" data-toggle="modal" data-target="#searchModal"><i class="fal fa-search"></i></a>
    </div>
    <div class="social-section">
        <?php
        if (have_rows('social_media_channels', 'option')) {
            while (have_rows('social_media_channels', 'option')) {
                the_row(); ?>
                <a href="<?= get_sub_field('full_url'); ?>">
                    <span class="fa-stack fa-2x">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="<?= get_sub_field('fa5_icon_class') ?> fa-stack-1x fa-inverse"></i>
                    </span>
                </a>
        <?php }
        }
        ?>
    </div>
</nav>

<div class="mobile-menu">
    <?php
    if (has_nav_menu('mobile_menu')) {
        wp_nav_menu(['theme_location' => 'mobile_menu', 'menu_class' => 'navigation']);
    }
    ?>
</div>

<nav class="header-nav">
    <?php if (!is_front_page()) { ?>
        <div class="header-bg"></div>
    <?php } ?>
    <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
        <?php if (is_front_page()) { ?>
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="573" height="471" viewBox="0 0 573 471">
                <image width="573" height="471" xlink:href="data:image/png;base64,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" />
            </svg>
        <?php } ?>
        <img src="<?= $companyLogo[0]; ?>" alt="<?php bloginfo('name'); ?>" />
    </a>
    <div class="select-mobile">
        <div class="select-menu">
            <button><span>Course Finder</span><i class="fas fa-chevron-down"></i></button>
            <div class="course-menu">

                <?php
                get_search_form();
                if (has_nav_menu('course_menu')) {
                    wp_nav_menu(['theme_location' => 'course_menu', 'menu_class' => 'course-menu__nav']);
                }
                ?>
            </div>
        </div>
    </div>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse mobile-collapse" id="navbarSupportedContent">
        <?php
        if (has_nav_menu('top_menu')) {
            wp_nav_menu(['theme_location' => 'top_menu', 'menu_class' => 'navigation']);
        }
        ?>
    </div>
    <div class="desktop-menu">
        <div class="row top-head-row">
            <div class="col-md-5 col-lg-12 col-xxl-5">
                <div class="contact-section">
                    <a class="mailto-link" href="mailto:admissions@almcollege.ac.uk">admissions@almcollege.ac.uk</a>
                    <a href="/contact"><i class="far fa-envelope"></i></a>
                    <a href="/visit-us/maps-directions/"><i class="fas fa-map-marker-alt"></i></a>
                    <a data-toggle="modal" data-target="#searchModal"><i class="fal fa-search"></i></a>
                </div>
            </div>
            <div class="col-md-7 col-lg-12 col-xxl-7">
                <div class="social-section">
                    <?php
                    if (have_rows('social_media_channels', 'option')) {
                        while (have_rows('social_media_channels', 'option')) {
                            the_row(); ?>
                            <a href="<?= get_sub_field('full_url'); ?>">
                                <span class="fa-stack fa-2x">
                                    <i class="fas fa-circle fa-stack-2x"></i>
                                    <i class="<?= get_sub_field('fa5_icon_class') ?> fa-stack-1x fa-inverse"></i>
                                </span>
                            </a>
                    <?php }
                    }
                    ?>
                </div>
                <?php
                if (has_nav_menu('top_menu')) {
                    wp_nav_menu(['theme_location' => 'top_menu', 'menu_class' => 'top-nav-desktop']);
                }
                ?>
            </div>
        </div>

        <div class="row bottom-head-row">
            <div class="col-md-12 col-lg-4 col-xl-5 col-xxl-5">
                <div class="select-menu">
                    <button><span>Course Finder</span><i class="fas fa-chevron-down"></i></button>
                    <div class="course-menu">
                        <form role="search" method="get" class="search-form" action="<?php echo home_url('/'); ?>">
                            <label>
                                <input type="search" class="search-field" placeholder="<?php echo esc_attr_x('Search …', 'placeholder') ?>" value="<?php echo get_search_query() ?>" name="s" title="<?php echo esc_attr_x('Search for:', 'label') ?>" />
                            </label>
                            <input type="hidden" name="post_type" value="course" />

                            <input type="submit" class="search-submit" value="<?php echo esc_attr_x('Go', 'submit button') ?>" />
                        </form>
                        <?php
                        if (has_nav_menu('course_menu')) {
                            wp_nav_menu(['theme_location' => 'course_menu', 'menu_class' => 'course-menu__nav']);
                        }
                        ?>
                    </div>
                </div>
            </div>
            <div class="col-md-12 col-lg-8 col-xl-7 col-xxl-7">
                <div class="main-nav">
                    <div class="" id="navbarSupportedContent">
                        <?php
                        if (has_nav_menu('main_menu')) {
                            wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation']);
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</nav>