<?php $relatedPost = get_field('related_news'); ?>
<div class="student-section">
    <h1><?= get_field('student_section_title'); ?></h1>
    <div class="row">
        <?php if (get_field('video_check')) { ?>
            <div class="cover-video embed-responsive embed-responsive-16by9">
                <?= get_field('video'); ?>
            </div> <?php
        } else { ?>

            <div class="cover-video course-block">
                <a href="<?= get_field('replacement_page_link'); ?>">
                    <img src="<?= get_field('replacement_image'); ?>">
                    <div class="content">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 595.39 214.52"><defs><style>.a-new{fill:#113a72;}</style></defs><title>tile-angle-device</title><polygon class="a-new" points="595.39 173.89 507.5 210.75 0 0 0 214.52 595.39 214.52 595.39 173.89"/></svg>
                        <h2><?= get_field('replacement_title'); ?></h2>
                    </div>
                </a>
            </div>

        <?php }; ?>
        <div class="related-post" href="<?= get_the_permalink($relatedPost[0]->ID); ?>">
            <h2>Related News</h2>
            <a href="<?= get_the_permalink($relatedPost[0]->ID); ?>">
                <div class="row">
                    <div class="cover-image">
                        <div class="img-wrap"><?= get_the_post_thumbnail($relatedPost[0]->ID, 'featured-post-home'); ?></div>
                    </div>
                    <div class="content">
                        <h2><?= get_the_title($relatedPost[0]->ID); ?>...</h2>
                        <span>Read Article <i class="fas fa-chevron-right"></i></span>
                    </div>
                </div>
            </a>
        </div>
    </div>
</div>
