<?php
$featuredBlocks = get_field('featured_content');
if ($featuredBlocks) { ?>
    <?php foreach ($featuredBlocks as $featuredBlock) {
        $featuredHomepage = get_field('featured_image_for_homepage', $featuredBlock->ID);
        $solidBG = get_field('slash_banner', $featuredBlock->ID);
        ?>
        <a class="home-featured-block" href="<?= get_permalink($featuredBlock->ID); ?>">
            <div class="row">
                <div class="featured-image">
                    <div class="image-wrap">
                        <?php if ($featuredHomepage) {
                            echo wp_get_attachment_image($featuredHomepage, 'home-featured-block');
                        } else {
                            echo get_the_post_thumbnail($featuredBlock->ID, 'home-featured-block');
                        } ?>
                    </div>
                </div>
                <div class="content">
                    <div class="wrap <?= $solidBG == true ? 'solid-bg' : ''; ?>">
                        <?php if (!$solidBG) { ?>
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 595.39 214.52"><defs><style>.a{fill:#f7f7f7;}</style></defs><title>tile-angle-device</title><polygon class="a" points="595.39 173.89 507.5 210.75 0 0 0 214.52 595.39 214.52 595.39 173.89"/></svg>
                        <?php } ?>
                        <h2><?= wp_trim_words(get_the_title($featuredBlock->ID), 4); ?></h2>
                        <p><?= wp_trim_words($featuredBlock->post_content, 5); ?></p>
                    </div>
                </div>
            </div>
        </a>
    <?php } ?>
<?php } ?>
