<?php

namespace Blue2\Scruffy;

class Utils extends \Blue2\Common\Theme\Utils
{

    public static function customLoop($postType)
    {

        if($postType == 'blog') {
            $args = [
                'post_type' => 'post',
                'posts_per_page' => '3',
                'post_status ' => 'publish',
                'category_name' => $postType
            ];

        } else {
            $args = [
                'post_type' => $postType,
                'posts_per_page' => '3',
                'post_status ' => 'publish',
            ];
        }


        $customQuery = new \WP_Query($args);


        if ($customQuery->have_posts()) {
            while ($customQuery->have_posts()) {
                $customQuery->the_post();
                get_template_part('templates/' . get_post_type() . '/content');
            }
        } else {
            get_template_part('templates/content', 'none');
        }
        wp_reset_postdata();
    }

    public static function taxonomyWrapped($headerName = "", $footerName = "", $postType)
    {
        get_header($headerName);
        locate_template('templates/' . $postType . '/taxonomy-archive.php', true);
        get_footer($footerName);
    }

    public static function blogSearchResults($results)
    {
        if (isset($_GET['post_type'])) {
            $postType = $_GET['post_type'];
        } else {
            $postType = ['post', 'page'];
        }

        if (isset($results['category-filter']) && $results['category-filter'] !== '') {
            $cats = $results['category-filter'];
        } else {
            $cats = 'blog';
        }

        $args = [
            'post_type' => $postType,
            's' => $results['search'],
            'posts_per_page' => '9',
            'category_name' => $cats,
            'post_status ' => 'publish',
        ];

        $customQuery = new \WP_Query($args);

        if ($customQuery->have_posts()) {
            while ($customQuery->have_posts()) {
                $customQuery->the_post();
                get_template_part('templates/post/content-blog');
            }
        }
        wp_reset_postdata();
    }

    public static function searchResults($results)
    {
        if (isset($_GET['post_type'])) {
            $postType = $_GET['post_type'];
        } else {
            $postType = ['post', 'page'];
        }

        $args = [
            'post_type' => $postType,
            's' => $results,
            'posts_per_page' => '9',
            'post_status ' => 'publish',
        ];

        $customQuery = new \WP_Query($args);

        if ($customQuery->have_posts()) {
            while ($customQuery->have_posts()) {
                $customQuery->the_post();
                get_template_part('templates/post/content');
            }
        } else {
            get_template_part('templates/content', 'none');
        }
        wp_reset_postdata();
    }

    public static function getPostsByCount()
    {
        $args = [
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => 5,
            'category_name' => 'blog',
            'meta_key' => 'post_count',
            'meta_value_num' => 1,
            'meta_compare' => '>=',
        ];


        $customQuery = new \WP_Query($args);

        if ($customQuery->have_posts()) {
            while ($customQuery->have_posts()) { ?>
                <div class="read-blog">
                    <?php
                    $customQuery->the_post();
                    echo get_the_date(); ?>
                    <a href="<?= the_permalink(); ?>"><?= the_title(); ?></a>
                </div>
            <?php }
        }
    }

    public static function taxonomyLoop($taxonomy)
    {
        if (have_posts()) {
            $checkFeatured = true;
            while (have_posts()) {
                the_post();
                if ($checkFeatured) {
                    $templates = [
                        'templates/' . get_post_type() . '/content-featured-' . $taxonomy . '.php',
                        'templates/' . get_post_type() . '/content-' . $taxonomy . '.php',
                    ];
                    locate_template($templates, true);
                    $checkFeatured = false;
                } else {
                    get_template_part('templates/' . get_post_type() . '/content-' . $taxonomy);
                }
            }
        } else { ?>
             <h2 class="col-md-12">There are no posts found in this category</h2>
        <?php }
    }

}