<?php
$image = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url() : get_template_directory_uri() . '/dist/images/person-default.png';

$hideProfile = get_field('hide_view_profile_button');

?>

<div class="col-sm-6 col-lg-12 col-xl-6 col-xxl-4 staff-block-col">
    <div class="staff-block">
        <div class="image-section" style="background-image:url('<?= $image; ?>')">
        </div>
        <div class="content-section">
            <div class="header-details">
                <h2 class="name">
                    <?php if($hideProfile == false || $hideProfile == NULL) { ?><a href="<?php the_permalink(); ?>"><?php } ?>
                        <?php the_title(); ?>
                    <?php if($hideProfile == false || $hideProfile == NULL) { ?></a><?php } ?>
                </h2>
                <h3 class="position"><?php the_field('position'); ?></h3>
            </div>
            <?php if(get_field('school') || get_field('department')){ ?>
            <div class="school-details">
                <?php if(get_field('school')) { ?><p><strong>School</strong>: <?php the_field('school'); ?></p><?php } ?>
                <?php if(get_field('department')) { ?><p><strong>Department</strong>: <?php the_field('department'); ?></p><?php } ?>
            </div>
            <?php } ?>
            <div class="contact-details">
                <ul>
                    <?php if(get_field('email')) { ?><li><i class="fal fa-envelope"></i><a href="mailto:<?php the_field('email') ?>"><?php the_field('email') ?></a></li><?php } ?>
                    <?php if(get_field('phone_number')) { ?><li><i class="fal fa-phone"></i><a href="tel:<?php the_field('phone_number') ?>"><?php the_field('phone_number') ?></a></li><?php } ?>
                </ul>
            </div>
            <div class="view-profile">
                <?php if($hideProfile == false || $hideProfile == NULL) { ?>
                <a href="<?php the_permalink(); ?>">View Profile</a>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
