<?php if (get_the_category()[0]->slug != 'blog') { ?>
    <section class="section-index section-index--index-sidebar"
             style="background-image:url('/content/themes/almcollege-theme/assets/images/admissions.png');">
        <div class="row">
            <div class="page-heading"><h1><?php the_title(); ?></h1></div>
            <div class="sidebar">
                <?php get_template_part('templates/parts/news-sidebar'); ?>
            </div>
            <div class="content-block">
                <div class="content">
                    <?php the_content(); ?>
                    <p>Share this via:</p>
                    <div class="addthis_inline_share_toolbox"></div>
                </div>
                <?php if (have_rows('slideshow')) { ?>
                    <div class="swiper-container-post">
                        <div class="swiper-wrapper">
                            <?php
                            while (have_rows('slideshow')) {
                                the_row();
                                $image = wp_get_attachment_image_url(get_sub_field('image'), 'home-featured-block'); ?>
                                <div class="swiper-slide"><img src="<?= $image; ?>"></div>
                            <?php } ?>
                        </div>
                        <div class="swiper-button-next-secondary"></div>
                        <div class="swiper-button-prev-secondary"></div>

                        <div class="swiper-pagination"></div>
                    </div>
                <?php } ?>
            </div>
    </section>
<?php } else { ?>
    <section class="section-index section-index--index-sidebar blog-post"
             style="background-image:url('/content/themes/almcollege-theme/assets/images/admissions.png');">
        <div class="row">
            <div class="page-heading"><p class="single-blog-meta"><?= get_the_date(); ?></p>
                <h1><?php the_title(); ?></h1></div>
            <div class="content-block">
                <div class="content">
                    <?php the_post_thumbnail('blog-header') ?>
                    <br>
                    <p>Share this via:</p>
                    <div class="addthis_inline_share_toolbox"></div>
                    <br>
                    <?php the_content(); ?>
                    <p>Share this via:</p>
                    <div class="addthis_inline_share_toolbox"></div>
                </div>
                <div class='navigation-blog'>
                    <span class='newer'><?php previous_post_link('%link', '<i class="far fa-long-arrow-left"></i> Previous Article'); ?></span>
                    <span class='older'><?php next_post_link('%link', 'Next Article <i class="far fa-long-arrow-right"></i>'); ?></span>
                </div>

            </div>
            <div class="sidebar">
                <form name="searchBlog" action="/category/blog" method="POST" class="search-blog">
                    <input name="search" placeholder="Search" class="search-field">
                    <button type="submit"><i class="fal fa-search"></i></button>

                    <select name="category-filter" class="category-filter">
                        <option value="">Filter by Category</option>
                        <option value="">All</option>
                        <option value="courses">Courses</option>
                        <option value="student-stories">Student Stories</option>
                    </select>
                </form>
                <div class="most-read">
                    <h2>Most read</h2>
                    <?= Blue2\Scruffy\Utils::getPostsByCount(); ?>
                </div>
                <div class="blog-sidebar">
                    <?php
                    $relatedPages = get_field('related_pages', 'option');
                    foreach ($relatedPages as $page) { ?>
                        <a href="<?= get_the_permalink($page->ID); ?>" class="related-page">
                            <?= get_the_post_thumbnail($page->ID, 'course-block'); ?>
                            <h2><?= get_the_title($page->ID); ?></h2>
                            <p><?= wp_trim_words(get_post_field('post_content', $page->ID), 25); ?></p>
                        </a>
                    <?php }
                    ?>
                </div>
            </div>
        </div>
    </section>
    <section class="section-index section-index--index-sidebar blog-post related-blogs">
        <h2>More Articles</h2>
        <div class="row">
            <?php
            $args = [
                'post_type' => 'post',
                'posts_per_page' => 3,
                'category_name' => 'blog',
                'post_status ' => 'publish',
            ];

            $relatedBlogs = new \WP_Query($args);
            while ($relatedBlogs->have_posts()) {
                $relatedBlogs->the_post();
                get_template_part('templates/post/content-blog');
            } ?>
            <?php wp_reset_postdata(); ?>
        </div>
    </section>
<?php } ?>