<?php
global $post;
$content = apply_filters('the_content', get_the_content());
$solidBG = get_field('slash_banner');

$categories = wp_get_post_categories($post->ID);
foreach($categories as $c){
    $cat = get_category( $c );
    $cats[] = array( 'name' => $cat->name, 'slug' => $cat->slug );
}
?>


<div class="course-block-blog">
    <article>
        <div class="content">
            <p class="meta"><?= get_the_date(); ?></p>
            <h2><?php the_title(); ?></h2>
            <p><?= wp_trim_words(get_the_content(), 20); ?></p>
            <a href="<?= the_permalink() ?>">Read more</a>
        </div>
        <div class="image-block">
            <a class="categories" href="/category/blog/<?= $cats[1]['slug']; ?>">Category: <strong><?= $cats[1]['name']; ?></strong></a>
            <?php if (has_post_thumbnail()) {
                the_post_thumbnail('blog');
            } else { ?>
                <img src="<?= get_template_directory_uri(); ?>/assets/images/AdvanceDiploma.jpg"
                     alt="Addvanced Diploma Image">
            <?php } ?>
        </div>
    </article>
</div>