<?php
$footerLogos = get_field('logos', 'options');
$companyLocation = get_field('company_location', 'options');
$companyLogo = get_field('company_logo', 'option');
$companyLogo = wp_get_attachment_image_src($companyLogo, 'full');

?>
<footer class="site-footer">
    <?php if (!is_front_page() && get_field('long_form_course_template') == true) { ?>
        <?php get_template_part('templates/homepage/slider'); ?>
        <div class="container-fluid section-homepage--content section-homepage--content__instagram">
            <h2><i class="fab fa-instagram"></i> Discover Diversity in Dundee. Follow our Instagram journey.</h2>
            <?= do_shortcode('[instagram-feed]') ?>
        </div>
    <?php } ?>
    <div class="container-fluid">
        <div class="row white-background">
            <nav class="navigation">
                <?php
                if (has_nav_menu('footer_one')) { ?>
                    <div class="footer-wrap">
                        <h2>About The College</h2>
                        <?php wp_nav_menu(array('theme_location' => 'footer_one', 'menu_class' => '')); ?>
                    </div>
                <?php }
                if (has_nav_menu('footer_two')) { ?>
                    <div class="footer-wrap">
                        <h2>Study</h2>
                        <?php wp_nav_menu(array('theme_location' => 'footer_two', 'menu_class' => '')); ?>
                    </div>
                <?php }
                if (has_nav_menu('footer_three')) { ?>
                    <div class="footer-wrap">
                        <h2>Student Life</h2>
                        <?php wp_nav_menu(array('theme_location' => 'footer_three', 'menu_class' => '')); ?>
                    </div>
                <?php }
                if (has_nav_menu('footer_four')) { ?>
                    <div class="footer-wrap">
                        <h2>Community</h2>
                        <?php wp_nav_menu(array('theme_location' => 'footer_four', 'menu_class' => '')); ?>
                    </div>
                <?php }
                if (has_nav_menu('footer_five')) { ?>
                    <div class="footer-wrap">
                        <h2>Visit Us</h2>
                        <?php wp_nav_menu(array('theme_location' => 'footer_five', 'menu_class' => '')); ?>
                    </div>
                <?php }
                ?>
                <div class="footer-wrap mobile">
                    <?php
                    foreach ($footerLogos as $footerLogo) { ?>
                        <a target="_blank" href="<?= $footerLogo['url']; ?>"><?= wp_get_attachment_image($footerLogo['image'], 'full'); ?> </a>
                    <?php }
                    ?>
                </div>
            </nav>
                <div class="footer-logos footer-logos--stacked">
                    <?php
                    foreach ($footerLogos as $footerLogo) { ?>
                        <a target="_blank" href="<?= $footerLogo['url']; ?>"><?= wp_get_attachment_image($footerLogo['image'], 'full'); ?> </a>
                    <?php }
                    ?>
                </div>
        
            <div class="footer-secondary col-md-12 col-lg-12 col-xl-12">
                <div class="row">
                    <div class="col-md-8">
                        <div class="row">
                            <form class="js-cm-form signup-form" id="subForm" class="js-cm-form" action="https://www.createsend.com/t/subscribeerror?description=" method="post" data-id="5B5E7037DA78A748374AD499497E309EA6A19ECAFB9CC7871D07E376CC4E7F1BB25546AED74AEC21D11EB2B924D0F4ADE673AA28CB25CA6A17B70A7C4DB5F2F1">
                                <div size="base" class="sc-jzJRlG bMslyb base">
                                    <div size="small" class="sc-jzJRlG liOVdz small fname">
                                        <div><input aria-label="First Name" id="fielddttijujy" maxLength="200" name="cm-f-dttijujy" class="sc-iwsKbI iMsgpL" placeholder="First Name" /></div>
                                    </div>
                                    <div size="small" class="sc-jzJRlG liOVdz small sname">
                                        <div><input aria-label="Last Name" id="fielddttijutj" maxLength="200" name="cm-f-dttijutj" class="sc-iwsKbI iMsgpL" placeholder="Last Name" /></div>
                                    </div>
                                    <div size="small" class="sc-jzJRlG liOVdz small email">
                                        <div><input autoComplete="Email" aria-label="Email" id="fieldEmail" maxLength="200" name="cm-okjnv-okjnv" required type="email" class="js-cm-email-input qa-input-email sc-iwsKbI iMsgpL" placeholder="Email" /></div>
                                    </div>
                                    <div class="signup-submit submit">
                                        <button size="1rem" color="#fff" type="submit" class="js-cm-submit-button sc-jKJlTe jHkwuK">Sign up to our newsletter</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-md-4">
                    </div>
                </div>
            </div>
        </div>
        <div class="row teal-background">
            <div class="copyright row">
                <div class="col-md-4">
                    <p class="line-one">Charity Number: <a href="https://www.oscr.org.uk/about-charities/search-the-register/charity-details?number=SC031415" target="_blank">SC031415</a> © <?php echo date("Y"); ?> <?php bloginfo('name'); ?></p>
                    <a class="copy-link" href="/privacy-policy">Privacy Policy</a>
                </div>
                <div class="col-md-6 footer-content">
                    <div class="row">
                        <div class="col-md-6 separator">
                            <p><?= $companyLocation['address']; ?></p>
                            <!-- <a class="mobile-contact" href="/contact">Contact us</a> -->
                        </div>
                        <div class="col-md-6">
                            <p class="footer-details"><a href="tel:<?= get_field('contact_phone_number', 'option'); ?>">T: <?= get_field('contact_phone_number', 'option'); ?></a></p>
                            <p class="footer-details"><a href="mailto:<?= get_field('contact_email_address', 'option'); ?>">E: <?= get_field('contact_email_address', 'option'); ?></a></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-2">
                    <p class="blue2">Website by <?php echo do_shortcode('[blue2_logo type="light"]'); ?></p>
                </div>
            </div>
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="613" height="355" viewBox="0 0 613 355">
                <image width="613" height="355" xlink:href="data:image/png;base64,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" /></svg>
            <div class="credit">
                <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                    <img src="<?= $companyLogo[0]; ?>" alt="<?php bloginfo('name'); ?>" />
                </a>
            </div>
        </div>
    </div>
</footer>
<div class="footer-mobile-menu">
    <?php wp_nav_menu(array('theme_location' => 'mobile_menu_bottom', 'menu_class' => '')); ?>
</div>
<div class="modal fade" id="searchModal" tabindex="-1" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <div class="modal-body">
                <i class="fal fa-search"></i>
                <?= get_search_form(); ?>
            </div>

        </div>
    </div>
</div>