<?php/* Template Name: Products Template */ ?>

<?php get_header(); ?>

<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
    <div class="product-template">
        <div class="container product-content">
            <h1><?php the_title(); ?></h1>
            <div class="col-lg-8">
                <div class="row">
                    <?php the_content(); ?>
                </div>
            </div>
        </div>

        <div class="container-fluid image-overlay">
            <div class="container image-cont">
                <img class='main-img' src="http://via.placeholder.com/1140x600" alt="" class="img-responsive">
            </div>
        </div>

        <div class="container-fluid info-block">

            <div class="container">
                <?php if( have_rows('info_blocks') ): ?>

                    <div class="info-products">

                        <div class="row row-eq-height justify-content-center">

                            <?php while ( have_rows('info_blocks') ) : the_row();

                                $img = get_sub_field('product_image');

                                ?>

                                <div class="col-md-6 col-lg-4 d-flex align-items-stretch">
                                    <div class="card d-flex align-items-stretch">
                                        <div class="card-body">
                                            <h5><?php the_sub_field('info_title'); ?></h5>
                                            <ul>
                                                <?php while ( have_rows('info_list') ) : the_row(); ?>
                                                    <li><?php the_sub_field('info_list_item'); ?></li>
                                                <?php endwhile; ?>
                                            </ul>
                                            <h5 class="card-title"><?php the_sub_field('product_title') ?></h5>
                                            <p class="card-text"><?php the_sub_field('product_description'); ?></p>
                                        </div>
                                    </div>
                                </div>

                            <?php endwhile; ?>


                        </div>

                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
<?php endwhile; endif; ?>

<?php get_template_part('/templates/parts/request-a-call')?>

<?php get_footer(); ?>
