<?php /* Template Name: Industry Template */ ?>

<?php get_header(); ?>

<?php if ( have_posts() ) {
    while (have_posts()) {
        the_post(); ?>
        <div class="industry-template">
            <div class="container industry-content">
                <div class="row">
                    <div class="col-lg-8">
                        <h1><?php the_title(); ?></h1>
                        <?php if(get_the_post_thumbnail_url()) { ?>
                            <img src="<?php the_post_thumbnail_url(); ?>" alt="" class="img-responsive industry-image">
                        <?php }
                        the_content(); ?>
                        </div>
                    <div class="col-lg-4">
                        <?php get_template_part('templates/parts/contact-sidebar'); ?>
                    </div>
                </div>
            </div>
            <div class="industry-block">
                <div class="container">
                    <?php if (have_rows('related_products')) { ?>
                        <div class="related-products">
                            <h2>Related Products</h2>
                            <div class="row row-eq-height justify-content-center">
                                <?php while (have_rows('related_products')) {
                                    the_row();
                                    $img = get_sub_field('product_image'); ?>
                                    <div class="col-md-6 col-lg-4 d-flex align-items-stretch">
                                        <div class="card d-flex align-items-stretch">
                                            <a href="<?php the_sub_field('product_link'); ?>">
                                                <?php if ($img) { ?>
                                                    <img class="card-img-top" src="<?= $img; ?>" alt="<?php the_sub_field('product_title'); ?>">
                                                <?php } ?>
                                            </a>
                                            <div class="card-body">
                                                <h5 class="card-title"><?php the_sub_field('product_title') ?></h5>
                                                <p class="card-text"><?php the_sub_field('product_description'); ?></p>
                                                <a href="<?php the_sub_field('product_link'); ?>">Read More</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } ?>

                </div>
            </div>
        </div>
    <?php }
} ?>

<?php get_template_part('/templates/parts/request-a-call')?>

<?php get_footer(); ?>