<?php /* Template Name: Design  Template */
get_header();

if ( have_posts() ) {
    while (have_posts()) {
        the_post();

        $boxClass = get_field('boxes') ? 'boxes-present' : 'no-boxes';

        ?>
        <div class="design-template">
            <div class="container design-content <?= $boxClass; ?>">
                <div class="row">
                    <div class="col-lg-8">
                        <h1><?php the_title(); ?></h1>
                        <?php the_content(); ?>
                    </div>
                    <div class="col-lg-4">
                        <?php get_template_part('templates/parts/contact-sidebar'); ?>
                    </div>
                </div>
            </div>

            <?php if( have_rows('boxes') ) {  ?>
                <div class="custom-boxes">
                    <div class="container">
                        <div class="row">
                            <?php while (have_rows('boxes')) {
                                the_row();
                                $image = get_sub_field('box_image');
                                ?>
                                <div class="col-md-6 col-lg-4 box-col">
                                    <div class="box-item" style="background-image:url('<?= $image['url']; ?>')">
                                        <a href="<?php the_sub_field('box_link'); ?>">
                                            <div class="caption"><?php the_sub_field('box_title'); ?></div>
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>

            <?php if (get_the_post_thumbnail_url()) {
                $imgpos = get_field('image_quote_position');
                $imgedits = $imgpos == 'text-left' ? 'left:40px' : 'right:40px'; ?>
                <div class="image-overlay">
                    <div class="container image-cont">
                        <img class='main-img img-responsive' src="<?php the_post_thumbnail_url(); ?>" alt="Quote Background">
                        <div class="image-quote col-sm-12 col-md-7 <?= $imgpos; ?>" style="<?= $imgedits; ?>">
                            <span style="color:<?php the_field('quote_color'); ?>"><?php the_field('image_quote'); ?></span>
                        </div>
                    </div>
                </div>
            <?php }

            $count = 0;
            if (have_rows('design_block_1')) { ?>
                <div class="design-block one">
                    <div class="container">
                        <div id="accordion">
                            <?php while (have_rows('design_block_1')) { the_row();
                                $count++ ?>
                                <div class="card card-number-<?= $count ?>">
                                    <div class="card-header" id="heading<?= $count ?>">
                                        <h5 class="mb-0">
                                            <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse<?= $count ?>" aria-expanded="true" aria-controls="collapse<?= $count ?>">
                                                <span class="accord-title"><?php the_sub_field('block_title'); ?></span><span class="the-icon"><i class="fal fa-plus"></i></span>
                                            </button>
                                        </h5>
                                    </div>
                                    <div id="collapse<?= $count ?>" class="collapse" aria-labelledby="heading<?= $count ?>" data-parent="#accordion">
                                        <div class="card-body">
                                            <?php the_sub_field('block_content'); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>


            <?php $count = 0;
            if (have_rows('design_block_2')) { ?>
                <div class="design-block two">
                    <div class="container">
                        <div id="accordion">
                            <h4><?php the_field('start_text'); ?></h4>
                            <?php while (have_rows('design_block_2')) {
                                the_row();
                                $count++ ?>
                                <div class="card card-number-<?= $count ?>">
                                    <div class="card-header" id="heading<?= $count ?>">
                                        <h5 class="mb-0">
                                            <a href="<?php the_sub_field('block_link'); ?>">
                                                <button class="btn btn-link collapsed bottom-accord"
                                                        data-toggle="collapse" data-target="#collapse<?= $count ?>"
                                                        aria-expanded="true" aria-controls="collapse<?= $count ?>">
                                                    <div class="accord-title"><?php the_sub_field('block_title'); ?></div>
                                                    <div class="the-icon"><i class="fal fa-long-arrow-right"></i></div>
                                                </button>
                                            </a>
                                        </h5>
                                    </div>
                                </div>
                            <?php } ?>
                            <h4><?php the_field('end_text'); ?></h4>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    <?php }
}
get_template_part('/templates/parts/request-a-call')?>

<?php get_footer(); ?>

