<?php /* Template Name: Contact Template */ ?>

<?php
    $phoneLink = explode('(0)',get_field('phone_number', 'option'));
    $phoneLink = implode($phoneLink); 
    $phoneLink = explode(' ',$phoneLink);
    $phoneLink = implode($phoneLink); 
    ?>
<?php get_header(); ?>

<?php if ( have_posts() ) {
    while (have_posts()) {
        the_post(); ?>
        <div class="contact-template">

            <div class="form-holder">
                <div class="container">
                    <h1><?php the_title(); ?></h1>
                    <?php
                        if (get_field('subtitle')){
                            ?>
                            <?= get_field('subtitle'); ?>
                            <?php
                        }
                    ?>
                    <?php if(get_field('contact_form_shortcode')) {
                        echo do_shortcode(get_field('contact_form_shortcode'));
                    } ?>
                </div>
            </div>

            <div class="container contact-content">
                <div class="row">
                    <div class="col-lg-6">
                        <?php the_content(); ?>
                        <ul>
                            <li>Tel:<a href="tel:<?=$phoneLink; ?>"><?php the_field('phone_number', 'option'); ?></a></li>
                            <li>Email:<a href="mailto:<?php the_field('email_address', 'option'); ?>"><?php the_field('email_address', 'option'); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="contact-secondary-content">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 contact__lower-col order-sm-2 order-lg-1">
                            <?php the_field('lower_left_column'); ?>
                        </div>
                        <div class="col-lg-6 map order-sm-1 order-lg-2">
                            <div id="map"></div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    <?php }
} ?>



<?php get_footer(); ?>

