import 'bootstrap';
import '@fortawesome/fontawesome';
import '@fortawesome/fontawesome-pro-solid';
import '@fortawesome/fontawesome-pro-regular';
import '@fortawesome/fontawesome-pro-light';
import '@fortawesome/fontawesome-free-brands';
import Swiper from 'swiper';

/* Font awesome - allow selectors in css */
window.FontAwesomeConfig.searchPseudoElements = true;

new Swiper('.swiper-container', {
    speed: 400,
    spaceBetween: 100,
    navigation: {
        nextEl: '.custom-swiper-next',
        prevEl: '.custom-swiper-prev',
    },
    pagination: {
        el: '.swiper-pagination',
        type: 'bullets',
        clickable: true
    },
});

$(document).ready(function() {
    /*  Search Animation + Functionality  */
    $('.nav-search a').on('click', function(event) {
        event.preventDefault();
        if (!$(this).hasClass('activated')) {
            $('.search-text').hide();
            if ($(window).width() < 992) {
                $(this).animate({ width: '100%' }, 300);
            } else {
                $(this).animate({ width: '300px' }, 300);
            }
            $('#custom-search-filter').show();
            $('.header-nav ul.navigation li.active a').css('opacity', '0.7');
            $('#mySearch').focus();
            $(this).addClass('activated');
        }
    });

    $('#mySearch').on('focusout', function() {
        $('.header-nav ul.navigation li.active a').css('opacity', '1');
        $('.nav-search a').removeClass('activated');
        if ($(window).width() < 992) {
            $('.nav-search a').animate({ width: '100%' }, 300);
        } else {
            $('.nav-search a').animate({ width: '132px' }, 300);
        }
        $('#custom-search-filter').hide();
        $('.search-text').show();
    });


    let animation = false;
    $('.design-block.one .card .btn-link').click(function() {
        if (animation === false) {
            animation = true;
            if ($(this).hasClass('collapsed')) {
                $('.design-block.one .card .btn-link svg')
                    .removeClass('fa-minus')
                    .addClass('fa-plus');
                $(this).find('svg')
                    .removeClass('fa-plus')
                    .addClass('fa-minus');
            } else {
                $('.design-block.one .card .btn-link svg').removeClass('fa-minus')
                    .addClass('fa-plus');
            }
            setTimeout(function() {
                animation = false;
            }, 350);
        }
    });

    if ($('.navbar-toggler').hasClass('collapsed')) {
        $(this).find('.navbar-toggler-icon')
            .hide();
    }

    /* Safari Detection */
    if (navigator.userAgent.indexOf('Safari') !== -1 &&
        navigator.userAgent.indexOf('Chrome') === -1) {
        $('body').addClass('safari');
    }

    /* Contact Map */
    if (window.location.href.indexOf('contact') > -1) {
        /* global google */
        const mapCenter = { lat: 56.5525365, lng: -2.6174338 };
        const map = new google.maps.Map(document.getElementById('map'), { zoom: 16, center: mapCenter });
        new google.maps.Marker({ position: mapCenter, map });
    }

    $('.nav-toggle').on('click', function() {
        $('.mobile-menu-output').slideToggle();
    });

    $('.mobile-menu .menu-item-has-children').on('click', function() {
        $(this).toggleClass('menu-open');
        $(this).find('.sub-menu')
            .slideToggle();
    });
});




