<?php get_header(); ?>

<div class="hero-carousel">
    <div class="swiper-container">
        <div class="swiper-wrapper">
            <?php if( have_rows('hero_items') ) { ?>
                <?php while (have_rows('hero_items')) {
                    the_row();
                    $image = get_sub_field('hero_image');
                    $cta = get_sub_field('hero_cta');
                    ?>
                    <div class="swiper-slide hero-slide d-flex align-items-center justify-content-center" style="background-image:url('<?= $image['url']; ?>');">
                        <div class="inner-slide">
                            <h2 class="hero-title"><?php the_sub_field('hero_item_title'); ?></h2>
                            <?php if($cta){ ?>
                                <div class="hero-cta">
                                    <a href="<?= $cta['url']; ?>"><?= $cta['title']; ?></a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
            <?php } ?>
        </div>
        <div class="swiper-pagination"></div>
        <div class="custom-swiper-prev custom-hero-nav">
            <i class="far fa-chevron-left fa-3x"></i>
        </div>
        <div class="custom-swiper-next custom-hero-nav">
            <i class="far fa-chevron-right fa-3x"></i>
        </div>
    </div>
</div>

<div class="home-contact-banner">
    <div class="request-a-call">
        <div class="container inner">
            <div class="row no-gutters">
                <div class="col-12 content-shift">
                    <div class="row">
                        <div class="col-12">
                            <h2>Contact Us</h2>
                        </div>
                        <div class="col-lg-4">
                            <p>For all enquiries, please contact Allards International Limited Head Office on:</p>
                        </div>
                        <div class="col-lg-4 banner-item">
                            <?php $email = get_field('email_address', 'option'); ?>
                            <h3><i class="far fa-envelope"></i> Email us at:</h3>
                            <p><a href="mailto:<?= $email; ?>"><?= $email; ?></a></p>
                        </div>
                        <div class="col-lg-4 banner-item">
                            <?php $tel = get_field('phone_number', 'option'); 
                                  $phoneLink = explode('(0)',get_field('phone_number', 'option'));
                                  $phoneLink = implode($phoneLink); 
                                  $phoneLink = explode(' ',$phoneLink);
                                  $phoneLink = implode($phoneLink);                                 
                            ?>
                            <h3><i class="fas fa-phone"></i> Call us on:</h3>
                            <p><a href="tel:<?= $phoneLink; ?>"><?= $tel; ?></a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_template_part('templates/parts/split-hero'); ?>

<div class="container home-content">
    <div class="row">
        <div class="col-lg-6">
            <h1><?php the_field('introduction_content_left'); ?></h1>
        </div>
        <div class="col-lg-6">
            <?php the_field('introduction_content_right'); ?>
        </div>
    </div>
</div>

<div class="block-content">
    <div class="container">
        <div class="row" id="box-search">
            <?php
            if( have_rows('block_items') ) {
                while (have_rows('block_items')) {
                    the_row(); ?>
                    <div class="col-md-6 col-lg-4">
                        <div class="thumbnail block-item text-center">
                            <a href="<?php the_sub_field('block_link'); ?>">
                                <?php if (get_sub_field('block_item_image')) { ?>
                                    <img src="<?php the_sub_field('block_item_image') ?>" alt="<?php the_sub_field('block_title'); ?>" class="img-responsive">
                                <?php } else { ?>
                                    <img src="http://via.placeholder.com/330x330" alt="" class="img-responsive">
                                <?php } ?>
                                <div class="caption">
                                    <p><?php the_sub_field('block_title'); ?></p>
                                </div>
                            </a>
                        </div>

                    </div>
                <?php }
            } ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>
