<?php get_header(); ?>
<div class="post-archive">
    <div class="container vacancy-content">
        <h1><?php the_field('vacancy_archive_title', 'option'); ?></h1>
    </div>
    <div class="container custom-vacancies">

        <div class="row">
            <div class="col-lg-8">
                <div class="vacancy-introduction">
                <?php the_field('vacancy_introduction', 'option'); ?>
                </div>
                <?php global $post;
                $args = [
                    "post_type" => 'vacancy',
                    "post_status" => 'publish',
                    'posts_per_page' => -1
                ];
                $count = 0;
                $vacancies = new WP_Query( $args );
                if($vacancies->have_posts()) {
                    while ($vacancies->have_posts()) {
                        $vacancies->the_post(); ?>

                        <div class="vacancy-item">
                            <h2><?php the_title(); ?></h2>
                            <?php if(get_field('date')) { ?><h3 class="date">Date: <?php the_field('date'); ?></h3><?php } ?>
                            <?php the_content(); ?>
                            <?php if( have_rows('qualifications') ) { ?>
                                <ul>
                                <?php while (have_rows('qualifications')) {
                                    the_row(); ?>
                                    <li><?php the_sub_field('qualification') ?></li>
                                <?php } ?>
                                </ul>
                            <?php } ?>

                        </div>

                    <?php }
                } else { ?>
                    <div class="vacancy-item no-vacancy">
                        <h2>There are currently no vacancies</h2>
                    </div>
                <?php }
                wp_reset_postdata();
                the_field('vacancy_conclusion', 'option');
                ?>
            </div>
            <div class="col-lg-4">
                <?php get_template_part('templates/parts/contact-sidebar'); ?>
            </div>
        </div>

    </div>
</div>

<?php get_template_part('/templates/parts/request-a-call')?>

<?php get_footer(); ?>
