<?php  $terms = get_terms('category',array( 'parent' => 0, 'hide_empty' => true, 'exclude'=>1 ) ); ?>

<div class="custom-products-archive">
    <div class="banner-top" style="background-image:url('<?php the_field('products_archive_hero', 'option') ?>')">
        <div class="banner-overlay"></div>
        <div class="container d-flex align-items-center h-100">
            <h1>Products</h1>
        </div>
    </div>
    <div class="container prod-container">
        <?php if(get_field('toggle_product_tabs', 'option') == true) { ?>
            <ul class="nav nav-tabs justify-content-center" id="myTab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="all-tab" data-toggle="tab" href="#all" role="tab" aria-controls="all" aria-selected="true">All Products</a>
                </li>
                <?php foreach($terms as $term){ ?>
                    <li class="nav-item">
                        <a class="nav-link" id="<?= $term->slug ?>-tab" data-toggle="tab" href="#<?= $term->slug ?>" role="tab" aria-controls="<?= $term->slug ?>" aria-selected="false"><?= $term->name ?></a>
                    </li>
                <?php } ?>
            </ul>
            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="all" role="tabpanel" aria-labelledby="all-tab">
                    <div class="row">
                        <?php B2\Scruffy\Utils::archiveLoop(); ?>
                    </div>
                </div>

                <?php foreach($terms as $term) {?>
                    <div class="tab-pane fade" id="<?= $term->slug ?>" role="tabpanel"
                        aria-labelledby="<?= $term->slug ?>-tab">
                        <?= do_shortcode('[get_category_listing id="' . $term->slug . '" count="-1" post-type="products"]'); ?>
                    </div>
                <?php } ?>
            </div>
        <?php }  else { ?>
            <div class="row">
                <?php B2\Scruffy\Utils::archiveLoop(); ?>
            </div>
        <?php } ?>


    </div>
</div>

