<?php
$term = get_the_terms(get_the_ID(), 'news-type');
$imageDir = get_template_directory_uri() . '/dist/images/animation-testing/';

if(get_the_post_thumbnail_url()){
    $img = get_the_post_thumbnail_url();
    $class = '';
}else{
    $img = $imageDir . '/aa-placeholder.png';
    $class = 'default-placeholder';
}
?>

<div class="col-12 order-1 related-case-studies">
    <div class="case-study-relation primary">
        <div class="row h-100 no-gutters">
            <div class="col-lg-6">
                <div class="img-section <?= $class; ?>" style="background-image:url('<?= $img; ?>')">
                    <?php if(get_field('event_date')) {  ?>
                        <div class="date-block">
                            <?php
                            $date = get_field('event_date', false, false);
                            $date = new DateTime($date);
                            ?>
                            <p><?= $date->format('d.m'); ?></p>
                        </div>
                    <?php } ?>
                    <a href="<?php the_permalink(); ?>" class="overlay"><i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="content-section">
                    <h3><?php the_title(); ?></h3>
                    <p>Date Posted: <?= get_the_date(); ?></p>
                    <p>Category: <?= $term[0]->name ?></p>
                    <?php the_excerpt(); ?>
                    <p><a href="<?php the_permalink(); ?>">Read More</a></p>
                </div>
            </div>
        </div>
    </div>
</div>
